package com.ejianc.business.bid.consts;

import java.util.HashMap;
import java.util.Map;

public enum ProjectTrackSurveyEnum {
    /**
     * 日期
     */
    ALLDATE("all","全部"),
    THISMON("thisMon","本月"),
    NEAR3MON("near3Mon","近三月"),
    NEAR6MON("near6Mon","近6个月"),
    THISYEAR("thisYear","今年"),
    LASTYEAR("lastYear","去年"),
    /**
     * 项目状态
     */
    RANGE_ALL("all","全部"),
    RANGE_TRACKING("tracking","跟踪中"),
    RANGE_STOP("stop","已终止"),
    RANGE_ENROLL("enroll","已评审"),
    RANGE_HASWIN("hasWin","已中标"),
    RANGE_NOTWIN("notWin","未中标"),
    /*
     * 项目类型
     * */
    PROJECT_TYPE_ALL("all","全部"),
    PROJECT_TYPE_SELF("self","自营"),
    PROJECT_TYPE_UNION("union","联营");

    private String code;

    private String description;

    private static Map<String, String> enumMap;

    //构造方法
    private ProjectTrackSurveyEnum(String code, String description ){
        this.code = code;
        this.description = description;
    }

    static {
        enumMap = new HashMap<>();
        for (ProjectTrackSurveyEnum value : values()) {
            enumMap.put(value.getCode(), value.getDescription());
        }
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static String getNameByCode(String code) {
        return enumMap.get(code);
    }
}
