package com.ejianc.business.bid.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 *   投标总结 
 * 
 * @author generator
 * 
 */
@ApiModel("  投标总结 ")
public class SummaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织名称")
    private String orgName;
    @ApiModelProperty("所属组织编码")
    private String orgCode;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("工程id")
    private Long enrollId;
    @ApiModelProperty("工程编码")
    private String engineeringCode;
    @ApiModelProperty("工程名称")
    private String engineeringName;
    @ApiModelProperty("开标日期(格式：yyyy-mm-dd)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date openTenderDate;
    @ApiModelProperty("评标办法id  (自定义档案)")
    private Long bidEvaluationId;
    @ApiModelProperty("评标办法")
    private String bidEvaluationMethod;
    @ApiModelProperty("项目负责人")
    private String projectLeader;
    @ApiModelProperty("建造师")
    private String architect;
    @ApiModelProperty("投标结果 0 已中标 1 未中标")
    private Integer bidResult;
    @ApiModelProperty("中标单位id")
    private Long bidWinnerId;
    @ApiModelProperty("中标单位")
    private String bidWinner;
    @ApiModelProperty("开标地点")
    private String bidOpeningPlace;
    @ApiModelProperty("中标日期(格式：yyyy-mm-dd)")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date winBiddingDate;
    @ApiModelProperty("报价形式 0:总价 1:费率")
    private Integer quotationForm;
    @ApiModelProperty("中标金额  （单位万元）")
    private BigDecimal bidMmy;
    @ApiModelProperty("招标控制价（单位万元）")
    private BigDecimal biddingControlMmy;
    @ApiModelProperty("报价下浮率（控制价）% ")
    private BigDecimal quoteLowerRate;
    @ApiModelProperty("投标报价费率 ")
    private BigDecimal bidQuotationRate;
    @ApiModelProperty("招标控制价费率")
    private BigDecimal biddingControlRate;
    @ApiModelProperty("报价下浮率（控制价）%")
    private BigDecimal controlQuoteLowerRate;
    @ApiModelProperty("工期")
    private BigDecimal duration;
    @ApiModelProperty("投标单位id")
    private Long bidUnitId;
    @ApiModelProperty("投标单位")
    private String bidUnit;
    @ApiModelProperty("单位负责人id")
    private Long unitLeaderId;
    @ApiModelProperty("投标代理人")
    private String biddingAgent;
    @ApiModelProperty("单位负责人")
    private String unitLeader;
    @ApiModelProperty("质量目标")
    private String qualityTarget;
    @ApiModelProperty("投标标段数量")
    private Integer bidSectionNumber;
    @ApiModelProperty("中标标段")
    private String bidWinningSection;
    @ApiModelProperty("备注")
    private String remarks;
    @ApiModelProperty("中标通知书返回状态 0 未选择 1 选择")
    private Integer notificationStatus;
    @ApiModelProperty("中标单位信息")
    private String bidWinnerNews;
    @ApiModelProperty("是否中标")
    private Integer isBidWinning;
    private String billStateName;
    private String bidResultName;
    private Integer useFlag; // 项目立项是否使用 1 是 0 否
    private Long builtConstructorId; // 建造师id
    private BigDecimal bidQuotationMny; // 投标报价金额
    private BigDecimal bidWinnerLowerRate; // 中标下浮率
    private BigDecimal bidWinningRate; // 中标率


    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 所属组织名称
     */
    public String getOrgCode() {
        return orgCode;
    }
    /**
     * 所属组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 工程id
     */
    @ReferSerialTransfer(referCode = "bid-enroll")
    public Long getEnrollId() {
        return enrollId;
    }
    /**
     * 工程id
     */
    @ReferDeserialTransfer
    public void setEnrollId(Long enrollId) {
        this.enrollId = enrollId;
    }


    /**
     * 工程编码
     */
    public String getEngineeringCode() {
        return engineeringCode;
    }

    /**
     * 工程编码
     */
    public void setEngineeringCode(String engineeringCode) {
        this.engineeringCode = engineeringCode;
    }
    /**
     * 工程名称
     */
    public String getEngineeringName() {
        return engineeringName;
    }

    /**
     * 工程名称
     */
    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    /**
     * 开标日期(格式：yyyy-mm-dd)
     */
    public java.util.Date getOpenTenderDate() {
        return openTenderDate;
    }

    /**
     * 开标日期(格式：yyyy-mm-dd)
     */
    public void setOpenTenderDate(java.util.Date openTenderDate) {
        this.openTenderDate = openTenderDate;
    }
    /**
     * 评标办法id  (自定义档案)
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBidEvaluationId() {
        return bidEvaluationId;
    }

    /**
     * 评标办法id  (自定义档案)
     */
    @ReferDeserialTransfer
    public void setBidEvaluationId(Long bidEvaluationId) {
        this.bidEvaluationId = bidEvaluationId;
    }
    /**
     * 评标办法  
     */
    public String getBidEvaluationMethod() {
        return bidEvaluationMethod;
    }

    /**
     * 评标办法  
     */
    public void setBidEvaluationMethod(String bidEvaluationMethod) {
        this.bidEvaluationMethod = bidEvaluationMethod;
    }
    /**
     * 项目负责人
     */
    public String getProjectLeader() {
        return projectLeader;
    }

    /**
     * 项目负责人
     */
    public void setProjectLeader(String projectLeader) {
        this.projectLeader = projectLeader;
    }
    /**
     * 建造师
     */
    public String getArchitect() {
        return architect;
    }

    /**
     * 建造师
     */
    public void setArchitect(String architect) {
        this.architect = architect;
    }

    /**
     * 投标结果 0 已中标 1 未中标
     */
    public Integer getBidResult() {
        return bidResult;
    }

    /**
     * 投标结果 0 已中标 1 未中标
     */
    public void setBidResult(Integer bidResult) {
        this.bidResult = bidResult;
    }
    /**
     * 中标单位id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBidWinnerId() {
        return bidWinnerId;
    }

    /**
     * 中标单位id
     */
    @ReferDeserialTransfer
    public void setBidWinnerId(Long bidWinnerId) {
        this.bidWinnerId = bidWinnerId;
    }
    /**
     * 中标单位
     */
    public String getBidWinner() {
        return bidWinner;
    }

    /**
     * 中标单位
     */
    public void setBidWinner(String bidWinner) {
        this.bidWinner = bidWinner;
    }
    /**
     * 开标地点
     */
    public String getBidOpeningPlace() {
        return bidOpeningPlace;
    }

    /**
     * 开标地点
     */
    public void setBidOpeningPlace(String bidOpeningPlace) {
        this.bidOpeningPlace = bidOpeningPlace;
    }
    /**
     * 中标日期(格式：yyyy-mm-dd)
     */
    public java.util.Date getWinBiddingDate() {
        return winBiddingDate;
    }

    /**
     * 中标日期(格式：yyyy-mm-dd)
     */
    public void setWinBiddingDate(java.util.Date winBiddingDate) {
        this.winBiddingDate = winBiddingDate;
    }
    /**
     * 报价形式 0:总价 1:费率
     */
    public Integer getQuotationForm() {
        return quotationForm;
    }

    /**
     * 报价形式 0:总价 1:费率
     */
    public void setQuotationForm(Integer quotationForm) {
        this.quotationForm = quotationForm;
    }
    /**
     * 中标金额  （单位万元）
     */
    public BigDecimal getBidMmy() {
        return bidMmy;
    }

    /**
     * 中标金额  （单位万元）
     */
    public void setBidMmy(BigDecimal bidMmy) {
        this.bidMmy = bidMmy;
    }
    /**
     * 招标控制价（单位万元）
     */
    public BigDecimal getBiddingControlMmy() {
        return biddingControlMmy;
    }

    /**
     * 招标控制价（单位万元）
     */
    public void setBiddingControlMmy(BigDecimal biddingControlMmy) {
        this.biddingControlMmy = biddingControlMmy;
    }
    /**
     * 报价下浮率（控制价）% 
     */
    public BigDecimal getQuoteLowerRate() {
        return quoteLowerRate;
    }

    /**
     * 报价下浮率（控制价）% 
     */
    public void setQuoteLowerRate(BigDecimal quoteLowerRate) {
        this.quoteLowerRate = quoteLowerRate;
    }
    /**
     * 投标报价费率 
     */
    public BigDecimal getBidQuotationRate() {
        return bidQuotationRate;
    }

    /**
     * 投标报价费率 
     */
    public void setBidQuotationRate(BigDecimal bidQuotationRate) {
        this.bidQuotationRate = bidQuotationRate;
    }
    /**
     * 招标控制价费率
     */
    public BigDecimal getBiddingControlRate() {
        return biddingControlRate;
    }

    /**
     * 招标控制价费率
     */
    public void setBiddingControlRate(BigDecimal biddingControlRate) {
        this.biddingControlRate = biddingControlRate;
    }
    /**
     * 报价下浮率（控制价）%
     */
    public BigDecimal getControlQuoteLowerRate() {
        return controlQuoteLowerRate;
    }

    /**
     * 报价下浮率（控制价）%
     */
    public void setControlQuoteLowerRate(BigDecimal controlQuoteLowerRate) {
        this.controlQuoteLowerRate = controlQuoteLowerRate;
    }
    /**
     * 工期
     */
    public BigDecimal getDuration() {
        return duration;
    }

    /**
     * 工期
     */
    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    /**
     * 投标单位id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBidUnitId() {
        return bidUnitId;
    }

    /**
     * 投标单位id
     */
    @ReferDeserialTransfer
    public void setBidUnitId(Long bidUnitId) {
        this.bidUnitId = bidUnitId;
    }
    /**
     * 投标单位
     */
    public String getBidUnit() {
        return bidUnit;
    }

    /**
     * 投标单位
     */
    public void setBidUnit(String bidUnit) {
        this.bidUnit = bidUnit;
    }
    /**
     * 单位负责人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getUnitLeaderId() {
        return unitLeaderId;
    }

    /**
     * 单位负责人id
     */
    @ReferDeserialTransfer
    public void setUnitLeaderId(Long unitLeaderId) {
        this.unitLeaderId = unitLeaderId;
    }
    /**
     * 单位负责人
     */
    public String getUnitLeader() {
        return unitLeader;
    }
    /**
     * 投标代理人
     */
    public String getBiddingAgent() {
        return biddingAgent;
    }
    /**
     * 投标代理人
     */
    public void setBiddingAgent(String biddingAgent) {
        this.biddingAgent = biddingAgent;
    }

    /**
     * 单位负责人
     */
    public void setUnitLeader(String unitLeader) {
        this.unitLeader = unitLeader;
    }
    /**
     * 质量目标
     */
    public String getQualityTarget() {
        return qualityTarget;
    }

    /**
     * 质量目标
     */
    public void setQualityTarget(String qualityTarget) {
        this.qualityTarget = qualityTarget;
    }
    /**
     * 投标标段数量
     */
    public Integer getBidSectionNumber() {
        return bidSectionNumber;
    }

    /**
     * 投标标段数量
     */
    public void setBidSectionNumber(Integer bidSectionNumber) {
        this.bidSectionNumber = bidSectionNumber;
    }
    /**
     * 中标标段
     */
    public String getBidWinningSection() {
        return bidWinningSection;
    }

    /**
     * 中标标段
     */
    public void setBidWinningSection(String bidWinningSection) {
        this.bidWinningSection = bidWinningSection;
    }

    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 中标通知书返回状态 0 未选择 1 选择
     */
    public Integer getNotificationStatus() {
        return notificationStatus;
    }

    /**
     * 中标通知书返回状态 0 未选择 1 选择
     */
    public void setNotificationStatus(Integer notificationStatus) {
        this.notificationStatus = notificationStatus;
    }
    /**
     * 中标单位信息
     */
    public String getBidWinnerNews() {
        return bidWinnerNews;
    }

    /**
     * 中标单位信息
     */
    public void setBidWinnerNews(String bidWinnerNews) {
        this.bidWinnerNews = bidWinnerNews;
    }
    /**
     * 是否中标
     */
    public Integer getIsBidWinning() {
        return isBidWinning;
    }

    /**
     * 是否中标
     */
    public void setIsBidWinning(Integer isBidWinning) {
        this.isBidWinning = isBidWinning;
    }
    /**
     * 单据状态名字
     */
    public String getBillStateName() {
        return billStateName;
    }
    /**
     * 单据状态名字
     */
    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    /**
     * 投标结果名字
     */
    public String getBidResultName() {
        return bidResultName;
    }
    /**
     * 投标结果名字
     */
    public void setBidResultName(String bidResultName) {
        this.bidResultName = bidResultName;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }
    @ReferSerialTransfer(referCode="income-arch")
    public Long getBuiltConstructorId() {
        return builtConstructorId;
    }
    @ReferDeserialTransfer
    public void setBuiltConstructorId(Long builtConstructorId) {
        this.builtConstructorId = builtConstructorId;
    }

    public BigDecimal getBidQuotationMny() {
        return bidQuotationMny;
    }

    public void setBidQuotationMny(BigDecimal bidQuotationMny) {
        this.bidQuotationMny = bidQuotationMny;
    }

    public BigDecimal getBidWinnerLowerRate() {
        return bidWinnerLowerRate;
    }

    public void setBidWinnerLowerRate(BigDecimal bidWinnerLowerRate) {
        this.bidWinnerLowerRate = bidWinnerLowerRate;
    }

    public BigDecimal getBidWinningRate() {
        return bidWinningRate;
    }

    public void setBidWinningRate(BigDecimal bidWinningRate) {
        this.bidWinningRate = bidWinningRate;
    }
}
