/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.InfoTrackRecordContentEntity;
import com.ejianc.business.bid.consts.ProjectTrackSurveyEnum;
import com.ejianc.business.bid.service.IInfoTrackRecordContentService;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.utils.AddressResolutionUtil;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.utils.EJCDateUtil;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.business.bid.vo.TrackDataVO;
import com.ejianc.business.bid.vo.TrackSimpleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectSurvey"})
public class ProjectSurveyController {
    @Autowired
    private IInfoTrackService infoTrackService;
    @Autowired
    private IDefdocApi defdocApi;
    private final String ENGINE_TYPE = "pro-market-project-engineeType";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInfoTrackRecordContentService infoTrackRecordContentService;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/projectCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> projectCount(@RequestParam(value="range", required=false) String range, @RequestParam(value="name", required=false) String name, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        Map<String, List<InfoTrackVO>> map;
        List<InfoTrackVO> vos = this.infoTrackService.trackCount(range, name, dateIn, orgId);
        HashSet<Object> provinceSet = new HashSet<Object>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pname = null;
        for (InfoTrackVO vo : vos) {
            if (StringUtils.isNotEmpty((CharSequence)vo.getArea())) {
                if (vo.getArea().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMmap = AddressResolutionUtil.addressResolution(vo.getArea());
                if (areaMmap != null) {
                    String province = areaMmap.get("province") == null ? "\u5176\u4ed6" : areaMmap.get("province");
                    String string = areaMmap.get("city") == null ? "\u5176\u4ed6" : areaMmap.get("city");
                    String string2 = areaMmap.get("county") == null ? "\u5176\u4ed6" : areaMmap.get("county");
                    vo.setProvince(province);
                    vo.setCity(string);
                    vo.setCounty(string2);
                    provinceSet.add(province);
                    citySet.add(string);
                    countySet.add(string2);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !string.equals(name)) continue;
                    pname = province;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, vos, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pname) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, vos, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, TrackDataVO> countyMap = new HashMap<String, TrackDataVO>();
                for (InfoTrackVO infoTrackVO : vos) {
                    String string = infoTrackVO.getCounty();
                    if (!countyMap.containsKey(string)) {
                        TrackDataVO pvo = new TrackDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        countyMap.put(string, pvo);
                        continue;
                    }
                    TrackDataVO projectDataVO = (TrackDataVO)countyMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    countyMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
                map = vos.stream().collect(Collectors.groupingBy(InfoTrackVO::getCounty));
                for (TrackDataVO trackDataVO : dataVOS) {
                    if (!map.containsKey(trackDataVO.getName())) continue;
                    List<InfoTrackVO> projectCountVOS = map.get(trackDataVO.getName());
                    ArrayList<TrackSimpleVO> projectVos = new ArrayList<TrackSimpleVO>();
                    for (InfoTrackVO projectCountVO : projectCountVOS) {
                        TrackSimpleVO projectVo = new TrackSimpleVO();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getEngineeringName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVos.add(projectVo);
                    }
                    trackDataVO.setProjectList(projectVos);
                }
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, TrackDataVO> cityMap = new HashMap<String, TrackDataVO>();
                for (InfoTrackVO infoTrackVO : vos) {
                    String string = infoTrackVO.getCity();
                    if (!cityMap.containsKey(string)) {
                        TrackDataVO pvo = new TrackDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        cityMap.put(string, pvo);
                        continue;
                    }
                    TrackDataVO projectDataVO = (TrackDataVO)cityMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    cityMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
                map = vos.stream().collect(Collectors.groupingBy(InfoTrackVO::getCity));
                for (TrackDataVO trackDataVO : dataVOS) {
                    if (!map.containsKey(trackDataVO.getName())) continue;
                    List<InfoTrackVO> projectCountVOS = map.get(trackDataVO.getName());
                    ArrayList<TrackSimpleVO> projectVos = new ArrayList<TrackSimpleVO>();
                    for (InfoTrackVO projectCountVO : projectCountVOS) {
                        TrackSimpleVO projectVo = new TrackSimpleVO();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getEngineeringName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVos.add(projectVo);
                    }
                    trackDataVO.setProjectList(projectVos);
                }
            }
        } else {
            rangeType = "China";
            HashMap<String, TrackDataVO> provinceMap = new HashMap<String, TrackDataVO>();
            for (InfoTrackVO infoTrackVO : vos) {
                String string = infoTrackVO.getProvince();
                if (!provinceMap.containsKey(string)) {
                    TrackDataVO pvo = new TrackDataVO();
                    pvo.setName(string);
                    pvo.setValue(Integer.valueOf(1));
                    provinceMap.put(string, pvo);
                    continue;
                }
                TrackDataVO projectDataVO = (TrackDataVO)provinceMap.get(string);
                projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                provinceMap.put(string, projectDataVO);
            }
            map = vos.stream().collect(Collectors.groupingBy(InfoTrackVO::getProvince));
            dataVOS = new ArrayList(provinceMap.values());
            for (TrackDataVO trackDataVO : dataVOS) {
                if (!map.containsKey(trackDataVO.getName())) continue;
                List<InfoTrackVO> projectCountVOS = map.get(trackDataVO.getName());
                ArrayList<TrackSimpleVO> projectVos = new ArrayList<TrackSimpleVO>();
                for (InfoTrackVO projectCountVO : projectCountVOS) {
                    TrackSimpleVO projectVo = new TrackSimpleVO();
                    projectVo.setId(projectCountVO.getId());
                    projectVo.setName(projectCountVO.getEngineeringName());
                    projectVo.setOrgId(projectCountVO.getOrgId());
                    projectVos.add(projectVo);
                }
                trackDataVO.setProjectList(projectVos);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", (Object)vos.size());
        jsonObject.put("data", dataVOS);
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        jsonObject.put("range", (Object)(rangeType == null || rangeType.contains("null") ? "China" : rangeType));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private List<TrackDataVO> projectCountByName(String name, List<InfoTrackVO> list, Integer type) {
        ArrayList dataVOS = new ArrayList();
        HashMap<String, TrackDataVO> map = new HashMap<String, TrackDataVO>();
        for (InfoTrackVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (!voName.equals(name)) continue;
            if (!map.containsKey(childrenName)) {
                TrackDataVO pvo = new TrackDataVO();
                pvo.setName(childrenName);
                pvo.setValue(Integer.valueOf(1));
                map.put(childrenName, pvo);
                continue;
            }
            TrackDataVO projectDataVO = (TrackDataVO)map.get(childrenName);
            projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
            map.put(childrenName, projectDataVO);
        }
        Map<String, List<InfoTrackVO>> projectCountVOMap = null;
        projectCountVOMap = type == 0 ? list.stream().collect(Collectors.groupingBy(InfoTrackVO::getCity)) : list.stream().collect(Collectors.groupingBy(InfoTrackVO::getCounty));
        ArrayList<TrackDataVO> projectDataVOS = new ArrayList<TrackDataVO>(map.values());
        for (TrackDataVO dataVO : projectDataVOS) {
            if (!map.containsKey(dataVO.getName())) continue;
            List<InfoTrackVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
            ArrayList<TrackSimpleVO> projectVos = new ArrayList<TrackSimpleVO>();
            for (InfoTrackVO projectCountVO : projectCountVOS) {
                TrackSimpleVO projectVo = new TrackSimpleVO();
                projectVo.setId(projectCountVO.getId());
                projectVo.setName(projectCountVO.getEngineeringName());
                projectVo.setOrgId(projectCountVO.getOrgId());
                projectVos.add(projectVo);
            }
            dataVO.setProjectList(projectVos);
        }
        return projectDataVOS;
    }

    @GetMapping(value={"countByEngineeType"})
    public CommonResponse<List<JSONObject>> countByEngineeType(@RequestParam(value="orgId", required=false) Long orgId, @RequestParam(value="yearType", required=false) String yearType) {
        ArrayList<JSONObject> resp = new ArrayList<JSONObject>();
        String year = EJCDateUtil.getYear() + "";
        if (yearType != null && "0".equals(yearType)) {
            year = EJCDateUtil.getYear() - 1 + "";
        }
        String thisYear = year;
        List<InfoTrackVO> trackVOS = this.infoTrackService.trackCount(null, null, "0".equals(yearType) ? ProjectTrackSurveyEnum.LASTYEAR.getCode() : null, orgId);
        CommonResponse docResp = this.defdocApi.getDefDocByDefCode("pro-market-project-engineeType");
        if (!docResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6863\u6848\u5206\u7c7b-{}\u4e0b\u6863\u6848\u5931\u8d25, {}", (Object)"pro-market-project-engineeType", (Object)JSONObject.toJSONString((Object)docResp));
            return CommonResponse.error((String)"\u83b7\u53d6\u9879\u76ee\u5de5\u7a0b\u7c7b\u578b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        JSONObject tmpMap = null;
        for (DefdocDetailVO doc : (List)docResp.getData()) {
            tmpMap = new JSONObject();
            tmpMap.put("name", (Object)doc.getName());
            tmpMap.put("typeId", (Object)doc.getId());
            tmpMap.put("totalNums", (Object)0);
            tmpMap.put("totalMny", (Object)BigDecimal.ZERO);
            resp.add(tmpMap);
        }
        tmpMap = new JSONObject();
        tmpMap.put("name", (Object)"\u5176\u4ed6");
        tmpMap.put("typeId", (Object)123L);
        tmpMap.put("totalNums", (Object)0);
        tmpMap.put("totalMny", (Object)BigDecimal.ZERO);
        resp.add(tmpMap);
        if (CollectionUtils.isNotEmpty(trackVOS)) {
            Map<Long, List<InfoTrackVO>> trackMap = trackVOS.stream().map(track -> {
                if (null == track.getEngineeType()) {
                    track.setEngineeType(Long.valueOf(123L));
                }
                return track;
            }).collect(Collectors.groupingBy(InfoTrackVO::getEngineeType));
            List<InfoTrackVO> tractList = null;
            for (JSONObject json : resp) {
                tractList = trackMap.get(json.getLong("typeId"));
                if (!CollectionUtils.isNotEmpty(tractList)) continue;
                json.put("totalNums", (Object)tractList.size());
                json.put("totalMny", (Object)tractList.stream().map(InfoTrackVO::getInvestorAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }

    @GetMapping(value={"businessStatusCount"})
    public CommonResponse<JSONObject> businessStatusCount(@RequestParam(value="orgId", required=false) Long orgId, @RequestParam(value="yearType", required=false) String yearType) {
        JSONObject resp = new JSONObject();
        String year = EJCDateUtil.getYear() + "";
        if (yearType != null && "0".equals(yearType)) {
            year = EJCDateUtil.getYear() - 1 + "";
        }
        String thisYear = year;
        Integer buildNum = 0;
        Integer thisYearProjectNum = 0;
        List<InfoTrackVO> trackVOS = this.infoTrackService.trackCount(null, null, "0".equals(yearType) ? ProjectTrackSurveyEnum.LASTYEAR.getCode() : null, orgId);
        resp.put("totalNumAll", (Object)trackVOS.size());
        resp.put("totalNum", (Object)trackVOS.size());
        HashMap<String, JSONObject> statusMap = new HashMap<String, JSONObject>();
        ArrayList<String> allTrackStatus = new ArrayList<String>();
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_TRACKING.getCode());
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_STOP.getCode());
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_ENROLL.getCode());
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_HASWIN.getCode());
        allTrackStatus.add(ProjectTrackSurveyEnum.RANGE_NOTWIN.getCode());
        JSONObject tmpStatus = null;
        for (InfoTrackVO e : trackVOS) {
            Integer n;
            Integer n2;
            if (ProjectTrackSurveyEnum.RANGE_TRACKING.getCode().equals(e.getTrackStatus())) {
                n2 = buildNum;
                n = buildNum = Integer.valueOf(buildNum + 1);
            }
            if (thisYear.equals(DateUtil.format(e.getCreateTime(), "yyyy"))) {
                n2 = thisYearProjectNum;
                n = thisYearProjectNum = Integer.valueOf(thisYearProjectNum + 1);
            }
            if (!statusMap.containsKey(e.getTrackStatus())) {
                tmpStatus = new JSONObject();
                tmpStatus.put("businessStatus", (Object)e.getTrackStatus());
                tmpStatus.put("businessStatusName", (Object)ProjectTrackSurveyEnum.getNameByCode((String)e.getTrackStatus()));
                tmpStatus.put("num", (Object)0);
                statusMap.put(e.getTrackStatus(), tmpStatus);
                allTrackStatus.remove(e.getTrackStatus());
            }
            tmpStatus = (JSONObject)statusMap.get(e.getTrackStatus());
            tmpStatus.put("num", (Object)(tmpStatus.getInteger("num") + 1));
            statusMap.put(e.getTrackStatus(), tmpStatus);
        }
        if (CollectionUtils.isNotEmpty(allTrackStatus)) {
            for (String trackStatus : allTrackStatus) {
                tmpStatus = new JSONObject();
                tmpStatus.put("businessStatus", (Object)trackStatus);
                tmpStatus.put("businessStatusName", (Object)ProjectTrackSurveyEnum.getNameByCode((String)trackStatus));
                tmpStatus.put("num", (Object)0);
                statusMap.put(trackStatus, tmpStatus);
            }
        }
        resp.put("buildNum", (Object)buildNum);
        resp.put("thisYearProjectNum", (Object)thisYearProjectNum);
        resp.put("detail", statusMap.values());
        return CommonResponse.success((Object)resp);
    }

    private String dofiter(String name) {
        if (name.length() <= 2) {
            return name;
        }
        String newName = name.substring(0, 2);
        int i = name.length() - 2;
        for (int j = 0; j < i; ++j) {
            newName = newName + "*";
        }
        return newName;
    }

    @ApiOperation(value="\u67e5\u8be2\u8ddf\u8e2a\u9879\u76ee\u4fe1\u606f\u5c55\u793a\u8868")
    @RequestMapping(value={"/queryListForTrack"}, method={RequestMethod.POST})
    public CommonResponse<IPage<InfoTrackVO>> queryListForTrack(@RequestBody QueryParam param) {
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (ObjectUtil.isNotEmpty((Object)param.getOrderMap())) {
            queryParam.put("orderType", param.getOrderMap().get("billDate"));
        }
        queryParam.put("pageSize", param.getPageSize());
        Integer startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() - 1) * param.getPageSize();
        queryParam.put("startLine", startLine);
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            queryParam.put("searchText", param.getSearchText());
        }
        Map parameterMap = param.getParams();
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        queryParam.put("orgIds", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        param.getParams().remove("orgId");
        for (String key : param.getParams().keySet()) {
            if ("billDate".equals(key)) {
                queryParam.put("billDateStart", ((Parameter)parameterMap.get(key)).getValue().toString().split(",")[0]);
                queryParam.put("billDateEnd", ((Parameter)parameterMap.get(key)).getValue().toString().split(",")[1]);
                continue;
            }
            queryParam.put(key, ((Parameter)parameterMap.get(key)).getValue());
        }
        Long total = this.infoTrackService.countNum(queryParam);
        Page resultPage = null;
        if (total == 0L) {
            resultPage = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            resultPage.setRecords(new ArrayList());
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resultPage);
        }
        resultPage = new Page((long)param.getPageIndex(), (long)param.getPageSize(), total.longValue());
        List<InfoTrackVO> list = this.infoTrackService.queryTrackList(queryParam);
        ArrayList result = new ArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Long, InfoTrackRecordContentEntity> map = this.getLongInfoTrackRecordContentEntityMap(list);
            list.forEach(record -> {
                InfoTrackVO infoTrackVO = (InfoTrackVO)BeanMapper.map((Object)record, InfoTrackVO.class);
                String engineeringName = this.dofiter(infoTrackVO.getEngineeringName());
                infoTrackVO.setEngineeringName(engineeringName);
                String constructionUnitName = this.dofiter(infoTrackVO.getConstructionUnitName());
                infoTrackVO.setConstructionUnitName(constructionUnitName);
                InfoTrackRecordContentEntity infoTrackRecordContentEntity = (InfoTrackRecordContentEntity)((Object)((Object)map.get(infoTrackVO.getId())));
                if (infoTrackRecordContentEntity != null) {
                    infoTrackVO.setTrackTime(infoTrackRecordContentEntity.getTrackTime());
                    infoTrackVO.setNewTrackStatus(infoTrackRecordContentEntity.getNewTrackStatus());
                }
                result.add(infoTrackVO);
            });
        }
        resultPage.setRecords(result);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resultPage);
    }

    @ApiOperation(value="\u5bfc\u51fa\u8ddf\u8e2a\u9879\u76ee\u4fe1\u606f\u5c55\u793a\u8868")
    @RequestMapping(value={"/excelTrackExport"}, method={RequestMethod.POST})
    public void excelTrackExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (ObjectUtil.isNotEmpty((Object)param.getOrderMap())) {
            queryParam.put("orderType", param.getOrderMap().get("billDate"));
        }
        queryParam.put("pageSize", param.getPageSize());
        Integer startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() - 1) * param.getPageSize();
        queryParam.put("startLine", startLine);
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            queryParam.put("searchText", param.getSearchText());
        }
        Map parameterMap = param.getParams();
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        queryParam.put("orgIds", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        param.getParams().remove("orgId");
        for (String key : param.getParams().keySet()) {
            if ("billDate".equals(key)) {
                queryParam.put("billDateStart", ((Parameter)parameterMap.get(key)).getValue().toString().split(",")[0]);
                queryParam.put("billDateEnd", ((Parameter)parameterMap.get(key)).getValue().toString().split(",")[1]);
                continue;
            }
            queryParam.put(key, ((Parameter)parameterMap.get(key)).getValue());
        }
        List<InfoTrackVO> list = this.infoTrackService.queryTrackList(queryParam);
        ArrayList result = new ArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Long, InfoTrackRecordContentEntity> map = this.getLongInfoTrackRecordContentEntityMap(list);
            list.forEach(record -> {
                Integer followState;
                InfoTrackVO infoTrackVO = (InfoTrackVO)BeanMapper.map((Object)record, InfoTrackVO.class);
                String engineeringName = this.dofiter(infoTrackVO.getEngineeringName());
                infoTrackVO.setEngineeringName(engineeringName);
                String constructionUnitName = this.dofiter(infoTrackVO.getConstructionUnitName());
                infoTrackVO.setConstructionUnitName(constructionUnitName);
                InfoTrackRecordContentEntity infoTrackRecordContentEntity = (InfoTrackRecordContentEntity)((Object)((Object)map.get(infoTrackVO.getId())));
                if (infoTrackRecordContentEntity != null) {
                    infoTrackVO.setTrackTime(infoTrackRecordContentEntity.getTrackTime());
                    infoTrackVO.setNewTrackStatus(infoTrackRecordContentEntity.getNewTrackStatus());
                }
                if ((followState = record.getFollowState()) == 1) {
                    infoTrackVO.setFollowStateName("\u8ddf\u8e2a\u4e2d");
                } else if (followState == 2) {
                    infoTrackVO.setFollowStateName("\u5df2\u8bc4\u5ba1");
                } else {
                    infoTrackVO.setFollowStateName("\u5df2\u7ed3\u675f");
                }
                if (StringUtils.isNotBlank((CharSequence)infoTrackVO.getTrackStatus())) {
                    infoTrackVO.setTrackStatusName(ProjectTrackSurveyEnum.getNameByCode((String)infoTrackVO.getTrackStatus()));
                }
                result.add(infoTrackVO);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", result);
        ExcelExport.getInstance().export("InfoTrackPeopleReportNew-export.xlsx", beans, response);
    }

    private Map<Long, InfoTrackRecordContentEntity> getLongInfoTrackRecordContentEntityMap(List<InfoTrackVO> records) {
        List ids = records.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(InfoTrackRecordContentEntity::getTrackId, ids);
        List list = this.infoTrackRecordContentService.list((Wrapper)queryWrapper);
        HashMap<Long, InfoTrackRecordContentEntity> map = new HashMap<Long, InfoTrackRecordContentEntity>();
        list.forEach(infoTrackRecordContentEntity -> {
            if (map.containsKey(infoTrackRecordContentEntity.getTrackId())) {
                if (map.get(infoTrackRecordContentEntity.getTrackId()) == null) {
                    map.put(infoTrackRecordContentEntity.getTrackId(), (InfoTrackRecordContentEntity)((Object)infoTrackRecordContentEntity));
                } else if (((InfoTrackRecordContentEntity)((Object)((Object)map.get(infoTrackRecordContentEntity.getTrackId())))).getTrackTime() == null || infoTrackRecordContentEntity.getTrackTime() != null && infoTrackRecordContentEntity.getTrackTime().after(((InfoTrackRecordContentEntity)((Object)((Object)map.get(infoTrackRecordContentEntity.getTrackId())))).getTrackTime())) {
                    map.put(infoTrackRecordContentEntity.getTrackId(), (InfoTrackRecordContentEntity)((Object)infoTrackRecordContentEntity));
                }
            } else {
                map.put(infoTrackRecordContentEntity.getTrackId(), (InfoTrackRecordContentEntity)((Object)infoTrackRecordContentEntity));
            }
        });
        return map;
    }
}

