/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.DeployChangeEntity;
import com.ejianc.business.bid.bean.DeployChangeHisEntity;
import com.ejianc.business.bid.bean.DeployContentChangeEntity;
import com.ejianc.business.bid.bean.DeployContentEntity;
import com.ejianc.business.bid.bean.DeployEntity;
import com.ejianc.business.bid.service.IDeployChangeHisService;
import com.ejianc.business.bid.service.IDeployChangeService;
import com.ejianc.business.bid.service.IDeployContentService;
import com.ejianc.business.bid.service.IDeployService;
import com.ejianc.business.bid.vo.DeployVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deployChange")
public class DeployChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IDeployChangeService deployChangeService;
    @Autowired
    private IDeployChangeHisService deployChangeHisService;
    @Autowired
    private IDeployService deployService;
    @Autowired
    private IDeployContentService deployContentService;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        DeployChangeEntity entity = (DeployChangeEntity)((Object)this.deployChangeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.deployChangeService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6295\u6807\u90e8\u7f72\u53d8\u66f4\u64a4\u56de\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        DeployChangeEntity planChange = (DeployChangeEntity)((Object)this.deployChangeService.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        this.deployChangeService.saveOrUpdate((Object)planChange, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6295\u6807\u90e8\u7f72\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        DeployChangeEntity planChange = (DeployChangeEntity)((Object)this.deployChangeService.selectById(billId));
        DeployEntity newPlanEntity = null;
        DeployEntity oldPlan = (DeployEntity)((Object)this.deployService.selectById(planChange.getSourceDeployId()));
        CommonResponse stringCommonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "EJCBT202505000001", "materPlan001", String.valueOf(oldPlan.getId()), "EJCBT202503000014", "attachMgr");
        if (!stringCommonResponse.isSuccess()) {
            this.logger.info("\u6295\u6807\u90e8\u7f72\u53d8\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        } else {
            this.logger.info("\u6295\u6807\u90e8\u7f72\u66f4\u9644\u4ef6\u590d\u5236\u5230\u4e3b\u9644\u4ef6------", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        if (state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            UserContext userContext = this.sessionManager.getUserContext();
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(userContext.getUserCode());
            planChange.setCommitUserName(userContext.getUserName());
        }
        planChange.setEffectiveDate(new Date());
        DeployChangeHisEntity recordEntity = (DeployChangeHisEntity)((Object)BeanMapper.map((Object)((Object)oldPlan), DeployChangeHisEntity.class));
        this.logger.info("\u6295\u6807\u90e8\u7f72\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03, \u603b\u8ba1\u5212\u53d8\u66f4\u4fe1\u606f\uff1a\u3010{}\u3011, \u53d8\u66f4\u524d\u6295\u6807\u90e8\u7f72\u4fe1\u606f: \u3010{}\u3011", (Object)JSON.toJSONString((Object)((Object)planChange)), (Object)JSON.toJSONString((Object)((Object)oldPlan)));
        recordEntity.setSourceDeployId(oldPlan.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());
        recordEntity.setChangeDeployId(planChange.getId());
        recordEntity.setChangeUserName(planChange.getChangeUserName());
        recordEntity.setChangeReason(planChange.getChangeReason());
        this.deployChangeHisService.saveOrUpdate((Object)recordEntity, false);
        this.deployChangeService.saveOrUpdate((Object)planChange, false);
        newPlanEntity = (DeployEntity)((Object)BeanMapper.map((Object)((Object)planChange), DeployEntity.class));
        newPlanEntity.setChangeState(DeployVO.PLAN_CHANGE_STATE_CHANGED);
        newPlanEntity.setCurChangingDeployId(null);
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        ArrayList<Long> delDetailIds = new ArrayList<Long>();
        ArrayList<DeployContentEntity> updatePlanDetail = new ArrayList<DeployContentEntity>();
        List<DeployContentEntity> oldList = oldPlan.getDetailList();
        Map<Long, DeployContentEntity> map1 = oldList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(BaseEntity::getId, item -> item, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty(newPlanEntity.getDetailList())) {
            for (DeployContentEntity detail2 : newPlanEntity.getDetailList()) {
                if (detail2.getChangeType() == 2) {
                    delDetailIds.add(detail2.getTargetId());
                    continue;
                }
                if (null != detail2.getTargetId()) {
                    if (!map1.containsKey(detail2.getTargetId())) continue;
                    DeployContentEntity masterPlanDetail = map1.get(detail2.getTargetId());
                    masterPlanDetail.setChangeType(detail2.getChangeType());
                    updatePlanDetail.add(masterPlanDetail);
                    continue;
                }
                detail2.setId(null);
                updatePlanDetail.add(detail2);
            }
        }
        if (CollectionUtils.isNotEmpty(updatePlanDetail)) {
            this.deployContentService.saveOrUpdateBatch(updatePlanDetail);
        }
        newPlanEntity.setDetailList(updatePlanDetail);
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.deployContentService.removeByIds(delDetailIds);
        }
        this.logger.info("\u56de\u663e\u539f\u8ba1\u5212\u5b50\u8868\u7ed3\u675f\uff01");
        this.deployService.saveOrUpdate((Object)newPlanEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if (state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            CommonResponse.success((String)"\u6709\u5ba1\u6279\u6d41\u7a0b\u7684\u53d8\u66f4\u603b\u8ba1\u5212\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        DeployChangeEntity planChange = (DeployChangeEntity)((Object)this.deployChangeService.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"change_deploy_id", (Object)billId);
        DeployChangeHisEntity hisEntity = (DeployChangeHisEntity)((Object)this.deployChangeHisService.getOne((Wrapper)hisQuery));
        if (null != hisEntity) {
            DeployEntity newPlanEntity = null;
            DeployEntity oldPlan = (DeployEntity)((Object)this.deployService.selectById(planChange.getSourceDeployId()));
            this.logger.info("\u603b\u8ba1\u5212\u6267\u884c\u5f03\u5ba1\u6570\u636e\u6062\u590d\u903b\u8f91\uff0c\u5f53\u524d\u6570\u636e\u3010{}\u3011\uff0c\u5f85\u6062\u590d\u6570\u636e\u3010{}\u3011", (Object)oldPlan, (Object)hisEntity);
            newPlanEntity = (DeployEntity)((Object)BeanMapper.map((Object)((Object)hisEntity), DeployEntity.class));
            newPlanEntity.setCurChangingDeployId(hisEntity.getChangeDeployId());
            newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
            newPlanEntity.setCreateTime(oldPlan.getCreateTime());
            newPlanEntity.setId(oldPlan.getId());
            newPlanEntity.setVersion(oldPlan.getVersion());
            newPlanEntity.setChangeState(DeployVO.PLAN_CHANGE_STATE_CHANGING);
            newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);
            ArrayList<Long> delDetailIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(planChange.getDetailList())) {
                ArrayList<DeployContentEntity> list = new ArrayList<DeployContentEntity>();
                DeployContentEntity tmp = null;
                Map<Long, Integer> map = oldPlan.getDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                for (DeployContentChangeEntity detail : planChange.getDetailList()) {
                    tmp = (DeployContentEntity)((Object)BeanMapper.map((Object)((Object)detail), DeployContentEntity.class));
                    if (null != detail.getTargetId()) {
                        tmp.setVersion(map.get(detail.getTargetId()));
                        tmp.setId(detail.getTargetId());
                        if (detail.getChangeType().equals("1")) {
                            delDetailIds.add(detail.getId());
                            continue;
                        }
                        list.add(tmp);
                        continue;
                    }
                    delDetailIds.add(detail.getId());
                }
                newPlanEntity.setDetailList(list);
            }
            if (CollectionUtils.isNotEmpty(delDetailIds)) {
                this.deployContentService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
            }
            this.deployChangeHisService.removeById(hisEntity.getId(), false);
            this.deployService.saveOrUpdate((Object)newPlanEntity, false);
        }
        if (this.deployChangeService.saveOrUpdate((Object)planChange, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success();
    }
}

