/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.DeployChangeEntity;
import com.ejianc.business.bid.bean.DeployContentChangeEntity;
import com.ejianc.business.bid.bean.DeployEntity;
import com.ejianc.business.bid.mapper.DeployChangeMapper;
import com.ejianc.business.bid.service.IDeployChangeService;
import com.ejianc.business.bid.service.IDeployService;
import com.ejianc.business.bid.vo.DeployChangeHisVO;
import com.ejianc.business.bid.vo.DeployChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deployChangeService")
public class DeployChangeServiceImpl
extends BaseServiceImpl<DeployChangeMapper, DeployChangeEntity>
implements IDeployChangeService {
    @Autowired
    private IDeployChangeService service;
    @Autowired
    private IDeployService deployService;
    @Autowired
    private DeployChangeMapper planChangeMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "BID_DEPLOY_CHANGE";

    @Override
    public List<DeployChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(DeployChangeEntity::getSourceDeployId, (Object)id);
        lambda.in(DeployChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List entities = super.list((Wrapper)lambda);
        List recordVOList = BeanMapper.mapList((Iterable)entities, DeployChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
            if (recordVO.getChangeVersion() < 10) {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-0" + recordVO.getChangeVersion());
            } else {
                recordVO.setHistoryCode(recordVO.getPlanCode() + "-" + recordVO.getChangeVersion());
            }
            recordVO.setChangeCode(recordVO.getPlanCode());
        });
        return recordVOList;
    }

    @Override
    public DeployChangeVO saveOrUpdate(DeployChangeVO planVo) {
        DeployChangeEntity planChangeEntity = this.service.getUnFinishedChange(planVo.getSourceDeployId());
        if (!(null == planChangeEntity || null != planVo.getId() && planChangeEntity.getId().equals(planVo.getId()))) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u6295\u6807\u90e8\u7f72\u53d8\u66f4\u5355\uff01");
        }
        DeployEntity masterPlan = (DeployEntity)((Object)this.deployService.getById(planVo.getSourceDeployId()));
        UserContext userContext = this.sessionManager.getUserContext();
        DeployChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = (DeployChangeEntity)((Object)BeanMapper.map((Object)planVo, DeployChangeEntity.class));
            saveEntity.setId(IdWorker.getId());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateTime(new Date());
        } else {
            saveEntity = (DeployChangeEntity)((Object)this.service.getById(planVo.getId()));
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setDetailList(BeanMapper.mapList((Iterable)planVo.getDetailList(), DeployContentChangeEntity.class));
        }
        List<DeployContentChangeEntity> beforeDetails = saveEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == saveEntity.getId()) {
            for (DeployContentChangeEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
            }
        }
        if (planVo.getId() == null || planVo.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)planVo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveEntity.setDeployCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)saveEntity, false);
        DeployEntity planEntity = (DeployEntity)((Object)this.deployService.selectById(saveEntity.getSourceDeployId()));
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingDeployId(saveEntity.getId());
            this.deployService.saveOrUpdate((Object)planEntity, false);
        }
        DeployChangeVO vo = (DeployChangeVO)BeanMapper.map((Object)((Object)saveEntity), DeployChangeVO.class);
        return vo;
    }

    @Override
    public DeployChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_deploy_id", (Object)sourcePlanId);
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (DeployChangeEntity)((Object)this.planChangeMapper.selectOne((Wrapper)query));
    }
}

