package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.*;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.service.IDeployService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.vo.DeployVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("deploy") 
public class DeployBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IDeployService service;
	@Autowired
	private IEnrollService enrollService;
	@Autowired
	private IRecordService recordService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InfoTrackServiceImpl infoTrackService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		logger.info("投标部署数据提交回调,billId:"+billId);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//审批完后需要 添加 投标状态
		DeployEntity entity = service.getById(billId);
		recordService.saveRecord(BidStageEnum.TOU_BIAO_BU_SHU, billId, entity.getProjectCode());

		//修改项目信息立项状态
		Long projectId = entity.getProjectId();
		LambdaQueryWrapper<InfoTrackEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(InfoTrackEntity::getId, projectId);
		InfoTrackEntity infoTrack = infoTrackService.getOne(wrapper);
		logger.info("infoTrack:对象值{}",infoTrack.toString());
		if(infoTrack != null){
			infoTrack.setIsDeploy(BidCommonConsts.YES);
		}
		infoTrackService.saveOrUpdate(infoTrack);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//删除记录
		LambdaQueryWrapper<RecordEntity> updateWrapper = new LambdaQueryWrapper<>();
		updateWrapper.eq(RecordEntity::getBillId, billId);
		recordService.remove(updateWrapper);

		DeployEntity masterPlanEntity = service.selectById(billId);

		if(masterPlanEntity!=null){
			if(masterPlanEntity.getChangeState() == DeployVO.PLAN_CHANGE_STATE_CHANGING){
				return CommonResponse.error("变更中单据无法撤回");
			}
			if(masterPlanEntity.getChangeState() == DeployVO.PLAN_CHANGE_STATE_CHANGED){
				return CommonResponse.error("已变更单据无法撤回");
			}
		}



		DeployEntity entity = service.getById(billId);
		//修改项目信息立项状态
		Long projectId = entity.getProjectId();
		LambdaQueryWrapper<InfoTrackEntity> wrapper = new LambdaQueryWrapper<InfoTrackEntity>()
				.eq(InfoTrackEntity::getId, projectId);
		InfoTrackEntity infoTrack = infoTrackService.getOne(wrapper);
		logger.info("infoTrack:对象值{}",infoTrack.toString());
		if(infoTrack != null){
			infoTrack.setIsDeploy(BidCommonConsts.NO);
		}
		infoTrackService.saveOrUpdate(infoTrack);

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
