/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.DeployContentEntity;
import com.ejianc.business.bid.bean.DeployEntity;
import com.ejianc.business.bid.enums.ChangeTypeEnum;
import com.ejianc.business.bid.mapper.DeployMapper;
import com.ejianc.business.bid.service.IDeployChangeService;
import com.ejianc.business.bid.service.IDeployContentService;
import com.ejianc.business.bid.service.IDeployService;
import com.ejianc.business.bid.vo.DeployContentVO;
import com.ejianc.business.bid.vo.DeployVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deployService")
public class DeployServiceImpl
extends BaseServiceImpl<DeployMapper, DeployEntity>
implements IDeployService {
    @Autowired
    private IDeployService service;
    @Autowired
    private IDeployContentService deployContentService;
    @Autowired
    private IDeployChangeService deployChangeService;

    @Override
    public DeployVO queryDetail(Long id) {
        DeployEntity deployEntity = (DeployEntity)((Object)this.service.selectById(id));
        DeployVO masterPlanVO = (DeployVO)BeanMapper.map((Object)((Object)deployEntity), DeployVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("deployId", new Parameter("eq", (Object)id));
        List detailEntityListDb = this.deployContentService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62\u9879.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (DeployContentEntity cdEntity : detailEntityList) {
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, DeployContentVO.class);
            masterPlanVO.setDetailList(resultMapList);
        } else {
            masterPlanVO.setDetailList(BeanMapper.mapList(detailEntityList, DeployContentVO.class));
        }
        if (null != deployEntity.getChangeVersion() && deployEntity.getChangeVersion() > 0) {
            masterPlanVO.setDeployChangeHisList(this.deployChangeService.queryDetailRecord(deployEntity.getId()));
        }
        return masterPlanVO;
    }
}

