package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.DeployContentEntity;
import com.ejianc.business.bid.enums.ChangeTypeEnum;
import com.ejianc.business.bid.service.IDeployChangeService;
import com.ejianc.business.bid.service.IDeployContentChangeService;
import com.ejianc.business.bid.service.IDeployContentService;
import com.ejianc.business.bid.vo.DeployContentVO;
import com.ejianc.business.bid.vo.DeployVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.DeployMapper;
import com.ejianc.business.bid.bean.DeployEntity;
import com.ejianc.business.bid.service.IDeployService;

import java.util.ArrayList;
import java.util.List;

/**
 * 投标部署
 * 
 * @author generator
 * 
 */
@Service("deployService")
public class DeployServiceImpl extends BaseServiceImpl<DeployMapper, DeployEntity> implements IDeployService{
    @Autowired
    private IDeployService service;
    @Autowired
    private IDeployContentService deployContentService;
    @Autowired
    private IDeployChangeService deployChangeService;

    @Override
    public DeployVO queryDetail(Long id) {
        DeployEntity deployEntity = service.selectById(id);
        DeployVO masterPlanVO = BeanMapper.map(deployEntity, DeployVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("deployId", new Parameter(QueryParam.EQ, id));
//        queryParam.getOrderMap().put("treeIndex", "asc");
        List<DeployContentEntity> detailEntityListDb = deployContentService.queryList(queryParam, false);

        List<DeployContentEntity> detailEntityList = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(DeployContentEntity cdEntity : detailEntityList){
                cdEntity.setRowState("edit");
            }
            List<DeployContentVO> resultMapList = BeanMapper.mapList(detailEntityList, DeployContentVO.class);
            masterPlanVO.setDetailList(resultMapList);

        } else {
            masterPlanVO.setDetailList(BeanMapper.mapList(detailEntityList, DeployContentVO.class));
        }

        if(null != deployEntity.getChangeVersion() && deployEntity.getChangeVersion() > 0){
            masterPlanVO.setDeployChangeHisList(deployChangeService.queryDetailRecord(deployEntity.getId()));
        }

        return masterPlanVO;
    }
}
