/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bid.consts.NoticeEnum;
import com.ejianc.business.bid.controller.SqlParam;
import com.ejianc.business.bid.service.EnrollMessageService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.vo.EnrollVO;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enrollWarn"})
public class EnrollWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EnrollMessageService messageService;
    @Autowired
    private IEnrollService enrollservice;
    private static int[] arr = new int[]{3, 5, 7};
    private static final String PC_A_URL = "/ejc-bid-frontend/#/enroll/card?id=";
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;

    @RequestMapping(value={"/expireWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> overdue(HttpServletRequest request) {
        this.logger.info("\u63a5\u6536\u5230\u6295\u6807\u62a5\u540dTask\u53c2\u6570\uff1a{}", (Object)request);
        List<EnrollVO> enrollVOS = this.enrollservice.queryBidOpeningSoon();
        if (CollectionUtils.isNotEmpty(enrollVOS)) {
            enrollVOS.forEach(item -> {
                String biddingDate = DateUtil.format((Date)item.getBiddingDate(), (String)"yyyy-MM-dd");
                String today = DateUtil.today();
                long l = DateUtil.parse((String)today).getTime() + (long)(arr[0] * 86400000);
                long l1 = DateUtil.parse((String)today).getTime() + (long)(arr[1] * 86400000);
                long l2 = DateUtil.parse((String)today).getTime() + (long)(arr[2] * 86400000);
                if (l == DateUtil.parse((String)biddingDate).getTime() || l1 == DateUtil.parse((String)biddingDate).getTime() || l2 == DateUtil.parse((String)biddingDate).getTime()) {
                    this.messageService.sendMsg((EnrollVO)item, new String[]{String.valueOf(item.getFollowPerson())}, NoticeEnum.BID_ENROLL);
                }
            });
        }
        return CommonResponse.success((String)"\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01");
    }

    @PostMapping(value={"enrollFollowWarn"})
    public CommonResponse<String> enrollFollowWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        String warnLevel = "";
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u8bc4\u5ba1\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u9879\u76ee\u8bc4\u5ba1\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u8bc4\u5ba1\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u9879\u76ee\u8bc4\u5ba1\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                sqlParamList.add(p);
            }
        }
        List<Map<String, Object>> result = this.enrollservice.queryWarn(sqlParamList);
        this.logger.info("\u6d88\u606f\u6761\u6570---{}", (Object)result.size());
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u3010\u9879\u76ee\u8bc4\u5ba1\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.get("bill_code").toString());
            vo.setPcTitle("\u9879\u76ee\u8bc4\u5ba1");
            vo.setPcUrl(PC_A_URL + m.get("id"));
            vo.setOrgId(Long.valueOf(m.get("org_id").toString()));
            vo.setOrgName(m.get("org_name").toString());
            vo.setSourceId(m.get("source_id").toString());
            vo.setTenantId(Long.valueOf((String)m.get("tenant_id")));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent);
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }
}

