/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bid.bean.DeployEntity;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.service.IDeployService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.business.bid.service.impl.InfoTrackServiceImpl;
import com.ejianc.business.bid.vo.DeployVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deploy")
public class DeployBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IDeployService service;
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IRecordService recordService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InfoTrackServiceImpl infoTrackService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6295\u6807\u90e8\u7f72\u6570\u636e\u63d0\u4ea4\u56de\u8c03,billId:" + billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        DeployEntity entity = (DeployEntity)((Object)this.service.getById(billId));
        this.recordService.saveRecord(BidStageEnum.TOU_BIAO_BU_SHU, billId, entity.getProjectCode());
        Long projectId = entity.getProjectId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getId, (Object)projectId);
        InfoTrackEntity infoTrack = (InfoTrackEntity)((Object)this.infoTrackService.getOne((Wrapper)wrapper));
        this.logger.info("infoTrack:\u5bf9\u8c61\u503c{}", (Object)((Object)((Object)infoTrack)).toString());
        if (infoTrack != null) {
            infoTrack.setIsDeploy(BidCommonConsts.YES);
        }
        this.infoTrackService.saveOrUpdate((Object)infoTrack);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
        updateWrapper.eq(RecordEntity::getBillId, (Object)billId);
        this.recordService.remove((Wrapper)updateWrapper);
        DeployEntity masterPlanEntity = (DeployEntity)((Object)this.service.selectById(billId));
        if (masterPlanEntity != null) {
            if (masterPlanEntity.getChangeState() == DeployVO.PLAN_CHANGE_STATE_CHANGING) {
                return CommonResponse.error((String)"\u53d8\u66f4\u4e2d\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
            if (masterPlanEntity.getChangeState() == DeployVO.PLAN_CHANGE_STATE_CHANGED) {
                return CommonResponse.error((String)"\u5df2\u53d8\u66f4\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
        }
        DeployEntity entity = (DeployEntity)((Object)this.service.getById(billId));
        Long projectId = entity.getProjectId();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)projectId);
        InfoTrackEntity infoTrack = (InfoTrackEntity)((Object)this.infoTrackService.getOne((Wrapper)wrapper));
        this.logger.info("infoTrack:\u5bf9\u8c61\u503c{}", (Object)((Object)((Object)infoTrack)).toString());
        if (infoTrack != null) {
            infoTrack.setIsDeploy(BidCommonConsts.NO);
        }
        this.infoTrackService.saveOrUpdate((Object)infoTrack);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

