/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bid.bean.InfoTrackStopEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.mapper.InfoTrackStopMapper;
import com.ejianc.business.bid.service.IInfoTrackStopService;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="infoTrackStopService")
public class InfoTrackStopServiceImpl
extends BaseServiceImpl<InfoTrackStopMapper, InfoTrackStopEntity>
implements IInfoTrackStopService {
    private static final String BILL_CODE = "BID_INFO_TRACK_STOP";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public void insertInfoTrackStop(InfoTrackVO vo) {
        UserContext userContext = this.sessionManager.getUserContext();
        if (vo != null && BidStateEnum.YI_JIE_SHU.getCode().equals(vo.getFollowState())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(InfoTrackStopEntity::getInfoTrackId, (Object)vo.getId());
            Long tenantId = InvocationInfoProxy.getTenantid();
            wrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
            wrapper.eq(BaseEntity::getDr, (Object)BidCommonConsts.NO);
            List list = ((InfoTrackStopMapper)this.baseMapper).selectList((Wrapper)wrapper);
            if (ListUtil.isEmpty((List)list)) {
                InfoTrackStopEntity entity = new InfoTrackStopEntity();
                entity.setInfoTrackId(vo.getId());
                entity.setEngineeringCode(vo.getBillCode());
                entity.setEngineeringName(vo.getEngineeringName());
                entity.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());
                entity.setApplyDate(new Date());
                entity.setStopReason("\u6295\u6807\u4fe1\u606f\u8ddf\u8e2a\u5df2\u4e2d\u6b62");
                entity.setEmployeeId(userContext.getUserId());
                entity.setEmployeeName(userContext.getUserName());
                entity.setBillDate(new Date());
                entity.setOrgId(vo.getOrgId());
                entity.setOrgName(vo.getOrgName());
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                entity.setBillCode((String)billCode.getData());
                this.saveOrUpdate((Object)entity, false);
            }
        }
    }
}

