/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialInquiry"})
@Api(value="\u6750\u6599\u8be2\u4ef7", tags={"\u6750\u6599\u8be2\u4ef7"})
public class MaterialInquiryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "MATERIAL_INQUIRY";
    @Autowired
    private IMaterialInquiryService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialInquiryVO saveOrUpdateVO) {
        MaterialInquiryEntity entity = (MaterialInquiryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialInquiryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setInquiryState(InquiryStateEnum.DEFAULT_STATE.getCode());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialInquiryVO vo = (MaterialInquiryVO)BeanMapper.map((Object)((Object)entity), MaterialInquiryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialInquiryVO> queryDetail(@RequestParam Long id) {
        MaterialInquiryEntity entity = (MaterialInquiryEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u8be6\u60c5\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728\uff01", null);
        }
        MaterialInquiryVO vo = (MaterialInquiryVO)BeanMapper.map((Object)((Object)entity), MaterialInquiryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialInquiryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialInquiryVO materialInquiryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialInquiryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("inquiryState")) {
            Integer inquiryState = Integer.parseInt(((Parameter)param.getParams().get("inquiryState")).getValue().toString());
            if (InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState) {
                param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate", new Parameter("lt", (Object)new Date()));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List vos = BeanMapper.mapList((Iterable)page.getRecords(), MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            if (param.getParams().containsKey("quoteEndDate")) {
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        }
        pageData.setRecords(vos);
        if (param.getParams().containsKey("quoteEndDate")) {
            param.getParams().remove("quoteEndDate");
            param.getParams().put("inquiryState", new Parameter("eq", (Object)InquiryStateEnum.EXPIRATION_STATE.getCode()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("purchaseSubject");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("inquiryState")) {
            Integer inquiryState = Integer.parseInt(((Parameter)param.getParams().get("inquiryState")).getValue().toString());
            if (InquiryStateEnum.EXPIRATION_STATE.getCode() == inquiryState) {
                param.getParams().put("inquiryState", new Parameter("in", Arrays.asList(InquiryStateEnum.QUOTATION_STATE.getCode(), InquiryStateEnum.EXPIRATION_STATE.getCode())));
                param.getParams().put("quoteEndDate", new Parameter("lt", (Object)new Date()));
            }
        }
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, MaterialInquiryVO.class);
        for (MaterialInquiryVO vo : vos) {
            if (param.getParams().containsKey("quoteEndDate")) {
                vo.setInquiryStateName(InquiryStateEnum.EXPIRATION_STATE.getDescription());
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("MaterialInquiry-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refMaterialInquiryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialInquiryVO>> refMaterialInquiryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialInquiryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

