/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.mapper.MaterialQuoteMapper;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.utils.VerifyCodeUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="materialQuoteService")
public class MaterialQuoteServiceImpl
extends BaseServiceImpl<MaterialQuoteMapper, MaterialQuoteEntity>
implements IMaterialQuoteService {
    @Resource
    private IMaterialInquiryService materialInquiryService;

    @Override
    public JSONObject generateQrCode(Long inquiryId) {
        JSONObject jsonObject = new JSONObject();
        return jsonObject;
    }

    @Override
    public void fetchVerifyCode(Long inquiryId, String phoneNumber, Boolean dialog) throws Exception {
        Assert.notNull((Object)inquiryId, (String)"\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialInquiryEntity materialInquiryEntity = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(inquiryId));
        if (materialInquiryEntity == null) {
            throw new BusinessException("\u8be5\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728\uff01");
        }
        materialInquiryEntity.getMaterialInquirySupplierList().stream().filter(materialInquirySupplierEntity -> phoneNumber.equals(materialInquirySupplierEntity.getTelephone())).findFirst().orElseThrow(() -> new BusinessException(Boolean.TRUE.equals(dialog) ? "\u8be5\u624b\u673a\u53f7\u65e0\u62a5\u4ef7\u6743\u9650\uff0c\u8bf7\u5207\u6362\u767b\u5f55\u624b\u673a\u53f7" : "\u8be5\u624b\u673a\u53f7\u65e0\u6743\u9650\u8bf7\u5207\u6362\u5176\u4ed6\u53f7\u7801\u91cd\u8bd5\uff01"));
        VerifyCodeUtil verifyCodeUtil = new VerifyCodeUtil();
        verifyCodeUtil.sendVerifyCode(phoneNumber, null);
    }

    @Override
    public void login(String phoneNumber, String validate) {
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)validate, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        VerifyCodeUtil verifyCodeUtil = new VerifyCodeUtil();
        verifyCodeUtil.checkVerifyCode(phoneNumber, validate, null);
    }
}

