/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.utils;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class VerifyCodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(VerifyCodeUtil.class);
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_195335074";
    private static final String TEMPLATE_CODE = "templateCode";
    private static final String VERIFY_CODE_ERROR = "\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25\uff01";
    @Resource
    private EnvironmentTools environmentTools;

    public void sendVerifyCode(String phoneNumber, String templateCode) throws Exception {
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)phoneNumber);
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            messageParam.put(TEMPLATE_CODE, (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put(TEMPLATE_CODE, (Object)templateCode);
        }
        String messageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
        logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a[{}]", (Object)phoneNumber, (Object)responseStr);
        CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
        }
    }

    public void checkVerifyCode(String phoneNumber, String validate, String templateCode) {
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)validate, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            jsonObject.put(TEMPLATE_CODE, (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            jsonObject.put(TEMPLATE_CODE, (Object)templateCode);
        }
        jsonObject.put("phone", (Object)phoneNumber);
        jsonObject.put("validate", (Object)validate);
        String checkMessageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/checkMessage";
        HttpResponse response = HttpUtil.createPost((String)checkMessageUrl).body(jsonObject.toJSONString()).execute();
        if (!response.isOk()) {
            throw new BusinessException(VERIFY_CODE_ERROR);
        }
        String responseStr = response.body();
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            throw new BusinessException(VERIFY_CODE_ERROR);
        }
        CommonResponse checkResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (0 != checkResponse.getCode()) {
            logger.info("\u6821\u9a8c\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)checkResponse.getMsg());
            throw new BusinessException(checkResponse.getMsg());
        }
    }
}

