package com.ejianc.business.bidprice.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.bidprice.material.bean.MaterialResultPurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultRentDetailEntity;
/**
 * 材料定标结果
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bidprice_material_result")
public class MaterialResultEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="quote_time")
    private Date quoteTime; // 报价时间
    @TableField(value="inquiry_id")
    private Long inquiryId; // 询价单id
    @TableField(value="picketage_id")
    private Long picketageId; // 定标单id
    @TableField(value="quote_id")
    private Long quoteId; // 供应商报价Id
    @TableField(value="supplier_id")
    private Long supplierId; // 中标供应商Id
    @TableField(value="supplier_name")
    private String supplierName; // 中标供应商名称
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 纳税人识别号
    @TableField(value="legal")
    private String legal; // 联系人
    @TableField(value="telephone")
    private String telephone; // 联系电话
    @TableField(value="total_mny")
    private BigDecimal totalMny; // 报价总金额
    @TableField(value="quote_memo")
    private String quoteMemo; // 报价备注
    @TableField(value="bid_flag")
    private Integer bidFlag; // 是否中标 0-未定标，1-已定标
    @TableField(value="bid_mny")
    private BigDecimal bidMny; // 中标金额
    @TableField(value="bid_memo")
    private String bidMemo; // 中标说明
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="materialResultPurchaseDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<MaterialResultPurchaseDetailEntity> materialResultPurchaseDetailList = new ArrayList<>(); // 材料定标结果-采购清单
    @TableField(exist=false)
    @SubEntity(serviceName="materialResultRentDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<MaterialResultRentDetailEntity> materialResultRentDetailList = new ArrayList<>(); // 材料定标结果-租赁清单
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }
    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public Long getPicketageId() {
        return picketageId;
    }

    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public String getQuoteMemo() {
        return quoteMemo;
    }

    public void setQuoteMemo(String quoteMemo) {
        this.quoteMemo = quoteMemo;
    }
    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public String getBidMemo() {
        return bidMemo;
    }

    public void setBidMemo(String bidMemo) {
        this.bidMemo = bidMemo;
    }
    
    public List<MaterialResultPurchaseDetailEntity> getMaterialResultPurchaseDetailList() {
        return materialResultPurchaseDetailList;
    }

    public void setMaterialResultPurchaseDetailList(List<MaterialResultPurchaseDetailEntity> materialResultPurchaseDetailList) {
        this.materialResultPurchaseDetailList = materialResultPurchaseDetailList;
    }
    public List<MaterialResultRentDetailEntity> getMaterialResultRentDetailList() {
        return materialResultRentDetailList;
    }

    public void setMaterialResultRentDetailList(List<MaterialResultRentDetailEntity> materialResultRentDetailList) {
        this.materialResultRentDetailList = materialResultRentDetailList;
    }
}
