package com.ejianc.business.bidprice.material.service.impl;

import com.ejianc.business.bidprice.material.bean.MaterialPicketageSupplierEntity;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageSupplierService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bidprice.material.mapper.MaterialPicketageMapper;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 材料定标
 * 
 * @author generator
 * 
 */
@Service("materialPicketageService")
public class MaterialPicketageServiceImpl extends BaseServiceImpl<MaterialPicketageMapper, MaterialPicketageEntity> implements IMaterialPicketageService{
    @Autowired
    private IMaterialPicketageSupplierService supplierService;
    @Override
    public boolean insertOrUpdate(MaterialPicketageEntity entity) {
        List<MaterialPicketageSupplierEntity> supplierList = new ArrayList<>();
        Boolean success = super.saveOrUpdate(entity,false);
        if(success){
            if(!ListUtil.isEmpty(entity.getMaterialPicketagePurchaseDetailList()) || !ListUtil.isEmpty(entity.getMaterialPicketageRentDetailList()) ){
                entity.getMaterialPicketagePurchaseDetailList().forEach(sub->{
                    supplierList.addAll(sub.getMaterialPicketageSupplierList());
                });
                entity.getMaterialPicketageRentDetailList().forEach(sub->{
                    supplierList.addAll(sub.getMaterialPicketageSupplierList());
                });
            }
            if (CollectionUtils.isNotEmpty(supplierList)){
                supplierService.saveOrUpdateBatch(supplierList);
            }
        }
        return true;
    }
}
