package com.ejianc.business.bidprice.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.mapper.MaterialQuoteMapper;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.utils.VerifyCodeUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * 报价记录
 *
 * @author baipengyan
 */
@Service("materialQuoteService")
public class MaterialQuoteServiceImpl extends BaseServiceImpl<MaterialQuoteMapper, MaterialQuoteEntity> implements IMaterialQuoteService {

	@Resource
	private IMaterialInquiryService materialInquiryService;

	/**
	 * 生成供应商报价二维码
	 *
	 * @param inquiryId 询价单id
	 *
	 * @return {@link JSONObject}
	 */
	@Override
	public JSONObject generateQrCode(Long inquiryId) {
		JSONObject jsonObject = new JSONObject();
		// TODO: 2023/2/7  固定的空白页面处理跳转逻辑
//		jsonObject.put("mobileH5Url", "");
		return jsonObject;
	}

	/**
	 * 获取验证码
	 *
	 * @param inquiryId   询价单id
	 * @param phoneNumber 电话号码
	 * @param dialog      是否是登录弹窗
	 */
	@Override
	public void fetchVerifyCode(Long inquiryId, String phoneNumber, Boolean dialog) throws Exception {
		Assert.notNull(inquiryId, "询价单id不能为空！");
		Assert.hasText(phoneNumber, "电话号码不能为空！");

		// 1、校验该手机号是否在询价单表体指定供应商手机号列表里
		MaterialInquiryEntity materialInquiryEntity = materialInquiryService.selectById(inquiryId);
		if (materialInquiryEntity == null) {
			throw new BusinessException("该询价单不存在！");
		}
		materialInquiryEntity.getMaterialInquirySupplierList()
				.stream()
				.filter(materialInquirySupplierEntity -> phoneNumber.equals(materialInquirySupplierEntity.getTelephone()))
				.findFirst()
				.orElseThrow(() -> new BusinessException(Boolean.TRUE.equals(dialog) ? "该手机号无报价权限，请切换登录手机号" : "该手机号无权限请切换其他号码重试！"));

		// 2、发送验证码
		VerifyCodeUtil verifyCodeUtil = new VerifyCodeUtil();
		verifyCodeUtil.sendVerifyCode(phoneNumber, null);
	}

	/**
	 * 登录
	 *
	 * @param phoneNumber 电话号码
	 * @param validate    验证码
	 */
	@Override
	public void login(String phoneNumber, String validate) {
		Assert.hasText(phoneNumber, "电话号码不能为空！");
		Assert.hasText(validate, "验证码不能为空！");

		// 1、校验验证码
		VerifyCodeUtil verifyCodeUtil = new VerifyCodeUtil();
		verifyCodeUtil.checkVerifyCode(phoneNumber, validate, null);
	}
}
