package com.ejianc.business.bidprice.material.utils;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

/**
 * 短信验证码工具类
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public class VerifyCodeUtil {
	private static final Logger logger = LoggerFactory.getLogger(VerifyCodeUtil.class);
	private static final String DEFAULT_TEMPLATE_CODE = "SMS_195335074";
	private static final String TEMPLATE_CODE = "templateCode";
	private static final String VERIFY_CODE_ERROR = "验证码校验失败！";
	@Value("${common.env.base-host}")
	private String BASE_HOST;

	/**
	 * 生成验证码
	 *
	 * @param phoneNumber  电话号码
	 * @param templateCode 模板代码
	 *
	 * @throws Exception 异常
	 */
	public void sendVerifyCode(String phoneNumber, String templateCode) throws Exception {
		Assert.hasText(phoneNumber, "电话号码不能为空！");

		JSONObject messageParam = new JSONObject();
		messageParam.put("phone", phoneNumber);
		if (StringUtils.isBlank(templateCode)) {
			messageParam.put(TEMPLATE_CODE, DEFAULT_TEMPLATE_CODE);
		} else {
			messageParam.put(TEMPLATE_CODE, templateCode);
		}

		String messageUrl = BASE_HOST + "/ejc-message-web/no_auth/sms/sendMessage";
		String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
		logger.info("向手机号[{}]发送验证码结果：[{}]", phoneNumber, responseStr);
		CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
		if (!response.isSuccess()) {
			throw new BusinessException("短信发送失败！");
		}
	}

	/**
	 * 校验验证码
	 *
	 * @param phoneNumber  电话号码
	 * @param validate     验证码
	 * @param templateCode 模板代码
	 */
	public void checkVerifyCode(String phoneNumber, String validate, String templateCode) {
		Assert.hasText(phoneNumber, "电话号码不能为空！");
		Assert.hasText(validate, "验证码不能为空！");

		JSONObject jsonObject = new JSONObject();
		if (StringUtils.isBlank(templateCode)) {
			jsonObject.put(TEMPLATE_CODE, DEFAULT_TEMPLATE_CODE);
		} else {
			jsonObject.put(TEMPLATE_CODE, templateCode);
		}
		jsonObject.put("phone", phoneNumber);
		jsonObject.put("validate", validate);

		String checkMessageUrl = BASE_HOST + "/ejc-message-web/no_auth/sms/checkMessage";
		HttpResponse response = HttpUtil.createPost(checkMessageUrl)
				.body(jsonObject.toJSONString())
				.execute();
		if (!response.isOk()) {
			throw new BusinessException(VERIFY_CODE_ERROR);
		}
		String responseStr = response.body();
		if (StringUtils.isBlank(responseStr)) {
			throw new BusinessException(VERIFY_CODE_ERROR);
		}
		CommonResponse<String> checkResponse = JSON.parseObject(responseStr, CommonResponse.class);
		if (0 != checkResponse.getCode()) {
			logger.info("校验验证码失败，失败原因：{}", checkResponse.getMsg());
			throw new BusinessException(checkResponse.getMsg());
		}
	}
}
