/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketagePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageQuoteEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageSupplierEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultPurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.PicketageQuotePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.PicketageQuoteRentDetailEntity;
import com.ejianc.business.bidprice.material.mapper.MaterialPicketageMapper;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageQuoteService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageSupplierService;
import com.ejianc.business.bidprice.material.service.IMaterialResultPurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialResultRentDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialResultService;
import com.ejianc.business.bidprice.material.service.IPicketageQuotePurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IPicketageQuoteRentDetailService;
import com.ejianc.business.bidprice.material.service.InquiryCommonService;
import com.ejianc.business.bidprice.material.service.impl.MaterialQuoteServiceImpl;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import com.ejianc.business.bidprice.material.vo.MaterialPicketagePurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="materialPicketageService")
public class MaterialPicketageServiceImpl
extends BaseServiceImpl<MaterialPicketageMapper, MaterialPicketageEntity>
implements IMaterialPicketageService {
    private static final Logger logger = LoggerFactory.getLogger(MaterialQuoteServiceImpl.class);
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_273725524";
    private static final String TEMPLATE_CODE = "templateCode";
    @Autowired
    private IMaterialPicketageSupplierService supplierService;
    @Autowired
    private IMaterialPicketageService service;
    @Autowired
    private IMaterialResultService materialResultService;
    @Autowired
    private IMaterialInquiryService inquiryService;
    @Autowired
    private IMaterialPicketageSupplierService materialPicketageSupplierService;
    @Autowired
    private InquiryCommonService inquiryCommonService;
    @Autowired
    private IPicketageQuotePurchaseDetailService purchaseDetailService;
    @Autowired
    private IPicketageQuoteRentDetailService rentDetailService;
    @Autowired
    private IMaterialSettlementApi materialSettlementApi;
    @Autowired
    private IMaterialResultPurchaseDetailService resultPurchaseDetailService;
    @Autowired
    private IMaterialResultRentDetailService resultRentDetailService;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private IMaterialPicketageQuoteService quoteService;

    @Override
    public boolean insertOrUpdate(MaterialPicketageEntity entity) {
        ArrayList supplierEntities = new ArrayList();
        ArrayList supplierList = new ArrayList();
        Boolean success = super.saveOrUpdate((Object)entity, false);
        if (!(!success.booleanValue() || ListUtil.isEmpty(entity.getMaterialPicketagePurchaseDetailList()) && ListUtil.isEmpty(entity.getMaterialPicketageRentDetailList()))) {
            entity.getMaterialPicketagePurchaseDetailList().forEach(sub -> supplierList.addAll(sub.getMaterialPicketageSupplierList()));
            if (entity.getPricingType() == 1) {
                List<MaterialPicketagePurchaseDetailEntity> purchaseList = entity.getMaterialPicketagePurchaseDetailList();
                List ids = purchaseList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(ids)) {
                    QueryParam param = new QueryParam();
                    param.getParams().put("picketageDetailId", new Parameter("in", ids));
                    List suppliers = this.supplierService.queryList(param, false);
                    if (!ListUtil.isEmpty((List)suppliers)) {
                        this.supplierService.removeByIds(suppliers.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                    }
                    purchaseList.forEach(sub -> sub.getMaterialPicketageSupplierList().forEach(supplier -> {
                        supplier.setPicketageId(entity.getId());
                        supplier.setPicketageDetailId(sub.getId());
                        supplierEntities.add(supplier);
                    }));
                }
            } else {
                List<MaterialPicketageRentDetailEntity> rentList = entity.getMaterialPicketageRentDetailList();
                List ids = rentList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(ids)) {
                    QueryParam param = new QueryParam();
                    param.getParams().put("picketageDetailId", new Parameter("in", ids));
                    List suppliers = this.supplierService.queryList(param, false);
                    if (!ListUtil.isEmpty((List)suppliers)) {
                        this.supplierService.removeByIds(suppliers.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                    }
                    rentList.forEach(sub -> sub.getMaterialPicketageSupplierList().forEach(supplier -> {
                        supplier.setPicketageId(entity.getId());
                        supplier.setPicketageDetailId(sub.getId());
                        supplierEntities.add(supplier);
                    }));
                }
            }
            if (CollectionUtils.isNotEmpty(supplierEntities)) {
                this.supplierService.saveOrUpdateBatch(supplierEntities, supplierEntities.size());
            }
        }
        return true;
    }

    @Override
    public void checkRefSave(MaterialPicketageEntity entity) {
        int count;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"inquiry_id", (Object)entity.getInquiryId());
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((count = super.count((Wrapper)queryWrapper)) > 0) {
            throw new BusinessException("\u4e00\u4e2a\u8be2\u4ef7\u7533\u8bf7\u5355\u53ea\u80fd\u6709\u4e00\u4e2a\u81ea\u7531\u6001\u7684\u5b9a\u6807\u5355\uff01");
        }
    }

    @Override
    public boolean insertOrUpdateRef(MaterialPicketageEntity entity) {
        Boolean success;
        if (!ListUtil.isEmpty(entity.getMaterialPicketageQuoteList())) {
            List collect = entity.getMaterialPicketageQuoteList().stream().filter(e -> e.getBidFlag() == 1).map(MaterialPicketageQuoteEntity::getSupplierId).collect(Collectors.toList());
            String bidWinnerIdStr = collect.stream().map(String::valueOf).collect(Collectors.joining(","));
            List nameList = entity.getMaterialPicketageQuoteList().stream().filter(e -> e.getBidFlag() == 1).map(MaterialPicketageQuoteEntity::getSupplierNameView).collect(Collectors.toList());
            String bidWinnerNameStr = nameList.stream().map(String::valueOf).collect(Collectors.joining(","));
            entity.setBidWinnerId(bidWinnerIdStr);
            entity.setBidWinnerName(bidWinnerNameStr);
        }
        if ((success = Boolean.valueOf(super.saveOrUpdate((Object)entity, false))).booleanValue()) {
            QueryWrapper purchaseWrapper = new QueryWrapper();
            purchaseWrapper.eq((Object)"picketage_id", (Object)entity.getId());
            List delPurchaseList = this.purchaseDetailService.list((Wrapper)purchaseWrapper);
            if (CollectionUtils.isNotEmpty((Collection)delPurchaseList)) {
                this.purchaseDetailService.removeByIds(delPurchaseList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
            }
            QueryWrapper rentWrapper = new QueryWrapper();
            rentWrapper.eq((Object)"picketage_id", (Object)entity.getId());
            List delRentList = this.rentDetailService.list((Wrapper)rentWrapper);
            if (CollectionUtils.isNotEmpty((Collection)delRentList)) {
                this.rentDetailService.removeByIds(delRentList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
            }
            if (CollectionUtils.isNotEmpty(entity.getMaterialPicketageQuoteList())) {
                ArrayList<PicketageQuotePurchaseDetailEntity> savePurchaseDetail = new ArrayList<PicketageQuotePurchaseDetailEntity>();
                ArrayList<PicketageQuoteRentDetailEntity> saveRentDetail = new ArrayList<PicketageQuoteRentDetailEntity>();
                List<MaterialPicketageQuoteEntity> quoteList = entity.getMaterialPicketageQuoteList();
                for (MaterialPicketageQuoteEntity quote : quoteList) {
                    if (CollectionUtils.isNotEmpty(quote.getPurchaseDetailList())) {
                        for (PicketageQuotePurchaseDetailEntity picketageQuotePurchaseDetailEntity : quote.getPurchaseDetailList()) {
                            picketageQuotePurchaseDetailEntity.setPicketageQuoteId(quote.getId());
                            picketageQuotePurchaseDetailEntity.setPicketageId(entity.getId());
                            picketageQuotePurchaseDetailEntity.setId(IdWorker.getId());
                        }
                        savePurchaseDetail.addAll(quote.getPurchaseDetailList());
                    }
                    if (!CollectionUtils.isNotEmpty(quote.getRentDetailList())) continue;
                    for (PicketageQuoteRentDetailEntity picketageQuoteRentDetailEntity : quote.getRentDetailList()) {
                        picketageQuoteRentDetailEntity.setPicketageQuoteId(quote.getId());
                        picketageQuoteRentDetailEntity.setPicketageId(entity.getId());
                        picketageQuoteRentDetailEntity.setId(IdWorker.getId());
                    }
                    saveRentDetail.addAll(quote.getRentDetailList());
                }
                if (CollectionUtils.isNotEmpty(savePurchaseDetail)) {
                    this.purchaseDetailService.saveOrUpdateBatch(savePurchaseDetail);
                }
                if (CollectionUtils.isNotEmpty(saveRentDetail)) {
                    this.rentDetailService.saveOrUpdateBatch(saveRentDetail);
                }
            }
        }
        return true;
    }

    @Override
    public void pushPicketage(Long billId) {
        MaterialPicketageEntity entity = (MaterialPicketageEntity)((Object)this.service.selectById(billId));
        if (entity.getSelfFlag() == 1) {
            MaterialResultEntity materialResultEntity = this.builderResultEntity(entity);
            this.materialResultService.saveOrUpdate((Object)materialResultEntity, false);
        } else {
            this.builderResultRef(entity);
        }
    }

    @Override
    public void rollBackPicketage(Long billId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"picketage_id", (Object)billId);
        List list = this.materialResultService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.materialResultService.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
    }

    public MaterialResultEntity builderResultEntity(MaterialPicketageEntity entity) {
        MaterialResultEntity result = new MaterialResultEntity();
        ArrayList<MaterialResultPurchaseDetailEntity> purchaseList = new ArrayList<MaterialResultPurchaseDetailEntity>();
        ArrayList<MaterialResultRentDetailEntity> rentList = new ArrayList<MaterialResultRentDetailEntity>();
        result.setPicketageId(entity.getId());
        if (StringUtils.isNotEmpty((String)entity.getBidWinnerId())) {
            result.setSupplierId(Long.parseLong(entity.getBidWinnerId()));
            result.setSupplierName(entity.getBidWinnerName());
        }
        result.setProjectId(entity.getProjectId());
        result.setProjectName(entity.getProjectName());
        result.setOrgId(entity.getOrgId());
        result.setOrgName(entity.getOrgName());
        result.setPurchaseSubject(entity.getName());
        result.setPricingType(entity.getPricingType());
        result.setPricingTypeName(entity.getPricingType() == 1 ? "\u91c7\u8d2d" : "\u79df\u8d41");
        result.setPurchaseType(entity.getPurchaseType());
        result.setPurchaseTypeName(entity.getPurchaseType() == 1 ? "\u9879\u76ee\u81ea\u91c7" : "\u516c\u53f8\u96c6\u91c7");
        result.setBillCode(entity.getBillCode());
        result.setInquiryMny(entity.getInquiryMny());
        result.setBidFlag(1);
        result.setHandleDate(entity.getHandleDate());
        result.setBidMny(entity.getBidWinMny());
        if (CollectionUtils.isNotEmpty(entity.getMaterialPicketagePurchaseDetailList()) || CollectionUtils.isNotEmpty(entity.getMaterialPicketageRentDetailList())) {
            MaterialPicketageSupplierEntity materialPicketageSupplierEntity;
            Map<Object, Object> winSupplierMap = new HashMap();
            if (StringUtils.isNotEmpty((String)entity.getBidWinnerId())) {
                QueryParam param = new QueryParam();
                param.getParams().put("supplierId", new Parameter("eq", (Object)Long.parseLong(entity.getBidWinnerId())));
                List supplierEntities = this.supplierService.queryList(param, false);
                winSupplierMap = supplierEntities.stream().collect(Collectors.toMap(k -> k.getPicketageDetailId(), k -> k));
            }
            for (MaterialPicketagePurchaseDetailEntity purchase : entity.getMaterialPicketagePurchaseDetailList()) {
                MaterialResultPurchaseDetailEntity resultPurchase = new MaterialResultPurchaseDetailEntity();
                resultPurchase.setMaterialCategoryId(purchase.getMaterialCategoryId());
                resultPurchase.setMaterialCategoryName(purchase.getMaterialCategoryName());
                resultPurchase.setMaterialId(purchase.getMaterialId());
                resultPurchase.setMaterialName(purchase.getMaterialName());
                resultPurchase.setSpec(purchase.getSpec());
                resultPurchase.setUnit(purchase.getUnit());
                resultPurchase.setResidueNum(purchase.getNum());
                resultPurchase.setReferPrice(purchase.getReferPrice());
                resultPurchase.setSourceId(purchase.getId());
                if (!winSupplierMap.isEmpty()) {
                    materialPicketageSupplierEntity = (MaterialPicketageSupplierEntity)((Object)winSupplierMap.get(purchase.getId()));
                    resultPurchase.setBidNum(purchase.getNum());
                    resultPurchase.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)materialPicketageSupplierEntity.getPrice(), (BigDecimal)purchase.getNum());
                    resultPurchase.setBidMny(mny);
                }
                purchaseList.add(resultPurchase);
            }
            for (MaterialPicketageRentDetailEntity rent : entity.getMaterialPicketageRentDetailList()) {
                MaterialResultRentDetailEntity resultRent = new MaterialResultRentDetailEntity();
                resultRent.setMaterialCategoryId(rent.getMaterialCategoryId());
                resultRent.setMaterialCategoryName(rent.getMaterialCategoryName());
                resultRent.setMaterialId(rent.getMaterialId());
                resultRent.setMaterialName(rent.getMaterialName());
                resultRent.setSpec(rent.getSpec());
                resultRent.setUnit(rent.getUnit());
                resultRent.setResidueNum(rent.getNum());
                resultRent.setReferPrice(rent.getReferPrice());
                resultRent.setRentTerm(rent.getRentTerm());
                resultRent.setRentMode(rent.getRentMode());
                resultRent.setSourceId(rent.getId());
                if (!winSupplierMap.isEmpty()) {
                    materialPicketageSupplierEntity = (MaterialPicketageSupplierEntity)((Object)winSupplierMap.get(rent.getId()));
                    resultRent.setBidNum(rent.getNum());
                    resultRent.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    BigDecimal perMny = ComputeUtil.safeMultiply((BigDecimal)materialPicketageSupplierEntity.getPrice(), (BigDecimal)rent.getNum());
                    resultRent.setBidMny(ComputeUtil.safeMultiply((BigDecimal)perMny, (BigDecimal)rent.getRentTerm()));
                }
                rentList.add(resultRent);
            }
        }
        if (CollectionUtils.isNotEmpty(rentList) || CollectionUtils.isNotEmpty(purchaseList)) {
            result.setMaterialResultRentDetailList(rentList);
            result.setMaterialResultPurchaseDetailList(purchaseList);
        }
        return result;
    }

    @Override
    public CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId) {
        JSONObject jsonObject = new JSONObject();
        Map<Object, Object> collect = new HashMap();
        MaterialInquiryEntity materialInquiryEntity = (MaterialInquiryEntity)((Object)this.inquiryService.selectById((Serializable)((Object)inquiryId)));
        MaterialInquiryVO inquiryVO = (MaterialInquiryVO)BeanMapper.map((Object)((Object)materialInquiryEntity), MaterialInquiryVO.class);
        InquiryCommonVO inquiryCommonVO = this.inquiryCommonService.queryDetailByInquiry(materialInquiryEntity.getId(), materialInquiryEntity.getInquiryState(), materialInquiryEntity.getPricingType().toString(), false);
        jsonObject.put("quoteList", (Object)inquiryCommonVO.getMaterialQuoteVOList());
        jsonObject.put("inquiry", BeanMapper.map((Object)((Object)materialInquiryEntity), MaterialInquiryVO.class));
        if (inquiryCommonVO.getPricingType().equals(new Integer(1))) {
            collect = inquiryCommonVO.getMaterialInquiryPurchaseDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryPurchaseDetailVO::getNum));
            jsonObject.put("materialInquiryPurchaseDetailList", (Object)inquiryCommonVO.getMaterialInquiryPurchaseDetailList());
        } else {
            collect = inquiryCommonVO.getMaterialInquiryRentDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryRentDetailVO::getNum));
            jsonObject.put("materialInquiryRentDetailList", (Object)inquiryCommonVO.getMaterialInquiryRentDetailList());
        }
        jsonObject.put("totalMap", collect);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @Override
    public JSONObject queryDetailToRef(Long id) {
        InquiryCommonVO inquiryCommonVO;
        MaterialPicketageEntity picketageEntity = (MaterialPicketageEntity)((Object)this.service.selectById(id));
        Map<Object, Object> collect = new HashMap();
        MaterialInquiryEntity byId = (MaterialInquiryEntity)((Object)this.inquiryService.selectById(picketageEntity.getInquiryId()));
        MaterialInquiryVO materialInquiry = (MaterialInquiryVO)BeanMapper.map((Object)((Object)byId), MaterialInquiryVO.class);
        collect = materialInquiry.getPricingType().equals(new Integer(1)) ? materialInquiry.getMaterialInquiryPurchaseDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryPurchaseDetailVO::getNum)) : materialInquiry.getMaterialInquiryRentDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryRentDetailVO::getNum));
        for (Object key : collect.keySet()) {
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"inquiry_id", (Object)picketageEntity.getInquiryId());
            ew.eq((Object)"source_id", key);
            ew.select(new String[]{"IFNULL(sum(bid_num),0) AS num"});
            Map map = this.purchaseDetailService.getMap((Wrapper)ew);
            BigDecimal num = ((BigDecimal)collect.get(key)).subtract((BigDecimal)map.get("num"));
            collect.put((Long)key, num);
        }
        Map<Object, Object> purchaseListMap = new HashMap();
        Map<Object, Object> rentListMap = new HashMap();
        QueryWrapper quotePurchaseWrapper = new QueryWrapper();
        quotePurchaseWrapper.eq((Object)"picketage_id", (Object)id);
        List purchaseDetailEntities = this.purchaseDetailService.list((Wrapper)quotePurchaseWrapper);
        if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) {
            purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuotePurchaseDetailEntity::getPicketageQuoteId));
        }
        QueryWrapper quoteRentWrapper = new QueryWrapper();
        quoteRentWrapper.eq((Object)"picketage_id", (Object)id);
        List rentDetailEntities = this.rentDetailService.list();
        if (CollectionUtils.isNotEmpty((Collection)rentDetailEntities)) {
            rentListMap = rentDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteRentDetailEntity::getPicketageQuoteId));
        }
        for (MaterialPicketageQuoteEntity quote : picketageEntity.getMaterialPicketageQuoteList()) {
            if (quote.getBidFlag() != 1) continue;
            if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) {
                quote.setPurchaseDetailList((List)purchaseListMap.get(quote.getId()));
            }
            if (!CollectionUtils.isNotEmpty((Collection)rentDetailEntities)) continue;
            quote.setRentDetailList((List)rentListMap.get(quote.getId()));
        }
        MaterialPicketageVO picketageVO = (MaterialPicketageVO)BeanMapper.map((Object)((Object)picketageEntity), MaterialPicketageVO.class);
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)picketageVO);
        if (picketageVO.getHandleDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            jsonObject.put("handleDate", (Object)sdf.format(picketageVO.getHandleDate()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(inquiryCommonVO = this.inquiryCommonService.queryDetailByInquiry(picketageEntity.getInquiryId(), materialInquiry.getInquiryState(), materialInquiry.getPricingType().toString(), false)).getMaterialInquiryPurchaseDetailList())) {
            jsonObject.put("picketagePurchaseDetailList", (Object)inquiryCommonVO.getMaterialInquiryPurchaseDetailList());
        }
        if (CollectionUtils.isNotEmpty((Collection)inquiryCommonVO.getMaterialInquiryRentDetailList())) {
            jsonObject.put("picketageRentDetailList", (Object)inquiryCommonVO.getMaterialInquiryRentDetailList());
        }
        jsonObject.put("totalMap", collect);
        return jsonObject;
    }

    @Override
    public MaterialPicketageVO queryMaterialPicketageDetail(Long id) {
        MaterialPicketageEntity entity = (MaterialPicketageEntity)((Object)this.service.selectById(id));
        MaterialPicketageVO vo = new MaterialPicketageVO();
        entity = this.querySupplier(entity);
        vo = (MaterialPicketageVO)BeanMapper.map((Object)((Object)entity), MaterialPicketageVO.class);
        vo = this.service.queryMaterialPriceArea(vo);
        return vo;
    }

    private MaterialPicketageEntity querySupplier(MaterialPicketageEntity entity) {
        if (!ListUtil.isEmpty(entity.getMaterialPicketagePurchaseDetailList()) || !ListUtil.isEmpty(entity.getMaterialPicketageRentDetailList())) {
            ArrayList detailIds = new ArrayList();
            List purchaseIds = entity.getMaterialPicketagePurchaseDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            List rentIds = entity.getMaterialPicketageRentDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            detailIds.addAll(purchaseIds);
            detailIds.addAll(rentIds);
            Map<Object, Object> supplierMap = new HashMap();
            if (CollectionUtils.isNotEmpty(detailIds)) {
                QueryParam param = new QueryParam();
                param.getParams().put("picketageDetailId", new Parameter("in", detailIds));
                List supplierEntities = this.materialPicketageSupplierService.queryList(param, false);
                if (CollectionUtils.isNotEmpty((Collection)supplierEntities)) {
                    supplierMap = supplierEntities.stream().collect(Collectors.groupingBy(MaterialPicketageSupplierEntity::getPicketageDetailId));
                }
                if (!supplierMap.isEmpty()) {
                    for (MaterialPicketageRentDetailEntity rent : entity.getMaterialPicketageRentDetailList()) {
                        rent.setMaterialPicketageSupplierList((List)supplierMap.get(rent.getId()));
                    }
                    for (MaterialPicketagePurchaseDetailEntity purchase : entity.getMaterialPicketagePurchaseDetailList()) {
                        purchase.setMaterialPicketageSupplierList((List)supplierMap.get(purchase.getId()));
                    }
                }
            }
        }
        return entity;
    }

    @Override
    public MaterialPicketageVO queryMaterialPriceArea(MaterialPicketageVO vo) {
        MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
        ArrayList<MaterialPriceVO> detail = new ArrayList<MaterialPriceVO>();
        List purchaseDetailList = vo.getMaterialPicketagePurchaseDetailList();
        if (CollectionUtils.isNotEmpty((Collection)purchaseDetailList)) {
            for (MaterialPicketagePurchaseDetailVO materialPicketagePurchaseDetailVO : purchaseDetailList) {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(materialPicketagePurchaseDetailVO.getMaterialId()));
                detail.add(materialPriceVO);
            }
        }
        if (CollectionUtils.isNotEmpty(detail)) {
            MaterialPriceVO materialPriceVO;
            List materialPriceVOS;
            priceVO.setDetail(detail);
            CommonResponse commonResponse = this.materialSettlementApi.queryPrice(priceVO);
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(materialPriceVOS = (materialPriceVO = (MaterialPriceVO)commonResponse.getData()).getDetail()))) {
                Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                List vos = vo.getMaterialPicketagePurchaseDetailList();
                if (CollectionUtils.isNotEmpty((Collection)vos)) {
                    for (MaterialPicketagePurchaseDetailVO materialPicketagePurchaseDetailVO : vos) {
                        Long materialId = materialPicketagePurchaseDetailVO.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (Objects.isNull(p)) continue;
                        materialPicketagePurchaseDetailVO.setMinPrice(p.getMinPrice());
                        materialPicketagePurchaseDetailVO.setMaxPrice(p.getMaxPrice());
                        materialPicketagePurchaseDetailVO.setPriceArea(p.getMinPrice().setScale(2, 4) + "~" + p.getMaxPrice().setScale(2, 4));
                    }
                    vo.setMaterialPicketagePurchaseDetailList(vos);
                }
            }
        }
        return vo;
    }

    public List<MaterialResultEntity> builderResultRef(MaterialPicketageEntity entity) {
        ArrayList<MaterialResultEntity> resultList = new ArrayList<MaterialResultEntity>();
        if (CollectionUtils.isNotEmpty(entity.getMaterialPicketageQuoteList())) {
            List<MaterialPicketageQuoteEntity> quoteList = entity.getMaterialPicketageQuoteList();
            Map<Object, Object> purchaseListMap = new HashMap();
            Map<Object, Object> rentListMap = new HashMap();
            ArrayList savePurchaseList = new ArrayList();
            ArrayList saveRentList = new ArrayList();
            QueryWrapper quotePurchaseWrapper = new QueryWrapper();
            quotePurchaseWrapper.eq((Object)"picketage_id", (Object)entity.getId());
            List purchaseDetailEntities = this.purchaseDetailService.list((Wrapper)quotePurchaseWrapper);
            if (CollectionUtils.isNotEmpty((Collection)purchaseDetailEntities)) {
                purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuotePurchaseDetailEntity::getPicketageQuoteId));
            }
            QueryWrapper quoteRentWrapper = new QueryWrapper();
            quoteRentWrapper.eq((Object)"picketage_id", (Object)entity.getId());
            List rentDetails = this.rentDetailService.list((Wrapper)quoteRentWrapper);
            if (CollectionUtils.isNotEmpty((Collection)rentDetails)) {
                rentListMap = rentDetails.stream().collect(Collectors.groupingBy(PicketageQuoteRentDetailEntity::getPicketageQuoteId));
            }
            for (MaterialPicketageQuoteEntity quote : quoteList) {
                if (quote.getBidFlag() != 1) continue;
                MaterialResultEntity result = new MaterialResultEntity();
                result.setId(IdWorker.getId());
                result.setPicketageId(entity.getId());
                result.setProjectId(entity.getProjectId());
                result.setProjectName(entity.getProjectName());
                result.setOrgId(entity.getOrgId());
                result.setOrgName(entity.getOrgName());
                result.setPurchaseSubject(entity.getName());
                result.setPricingType(entity.getPricingType());
                result.setPricingTypeName(entity.getPricingType() == 1 ? "\u91c7\u8d2d" : "\u79df\u8d41");
                result.setPurchaseType(entity.getPurchaseType());
                result.setPurchaseTypeName(entity.getPurchaseType() == 1 ? "\u9879\u76ee\u81ea\u91c7" : "\u516c\u53f8\u96c6\u91c7");
                result.setBillCode(entity.getBillCode());
                result.setInquiryMny(entity.getInquiryMny());
                result.setBidFlag(1);
                result.setHandleDate(entity.getHandleDate());
                result.setBidMny(quote.getBidMny());
                result.setSupplierId(quote.getSupplierId());
                result.setSupplierName(quote.getSupplierName());
                result.setSocialCreditCode(quote.getSocialCreditCode());
                result.setLegal(quote.getLegal());
                result.setInquiryId(entity.getInquiryId());
                result.setQuoteId(quote.getQuoteId());
                result.setTelephone(quote.getTelephone());
                result.setBidMemo(quote.getBidMemo());
                result.setBidFlag(quote.getBidFlag());
                result.setQuoteMemo(quote.getQuoteMemo());
                result.setHandleDate(quote.getQuoteTime());
                result.setTotalMny(quote.getPurchaseMny());
                if (entity.getPricingType() == 1) {
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)purchaseListMap.get(quote.getId())))) {
                        List purchaseDetailList = (List)purchaseListMap.get(quote.getId());
                        ArrayList<MaterialResultPurchaseDetailEntity> materialResultPurchaseDetail = new ArrayList<MaterialResultPurchaseDetailEntity>();
                        for (PicketageQuotePurchaseDetailEntity purchase : purchaseDetailList) {
                            MaterialResultPurchaseDetailEntity purchaseDetail = new MaterialResultPurchaseDetailEntity();
                            purchaseDetail.setId(IdWorker.getId());
                            purchaseDetail.setPid(result.getId());
                            purchaseDetail.setSourceId(purchase.getId());
                            purchaseDetail.setMaterialCategoryId(purchase.getMaterialCategoryId());
                            purchaseDetail.setMaterialCategoryName(purchase.getMaterialCategoryName());
                            purchaseDetail.setMaterialId(purchase.getMaterialId());
                            purchaseDetail.setMaterialName(purchase.getMaterialName());
                            purchaseDetail.setSpec(purchase.getSpec());
                            purchaseDetail.setUnit(purchase.getUnit());
                            purchaseDetail.setResidueNum(purchase.getResidueNum());
                            purchaseDetail.setReferPrice(purchase.getReferPrice());
                            purchaseDetail.setBidNum(purchase.getBidNum());
                            purchaseDetail.setBidPrice(purchase.getBidPrice());
                            purchaseDetail.setBidMny(purchase.getBidMny());
                            materialResultPurchaseDetail.add(purchaseDetail);
                        }
                        savePurchaseList.addAll(materialResultPurchaseDetail);
                    }
                } else if (CollectionUtils.isNotEmpty((Collection)((Collection)rentListMap.get(quote.getId())))) {
                    List rentDetailList = (List)rentListMap.get(quote.getId());
                    ArrayList<MaterialResultRentDetailEntity> rentDetailEntities = new ArrayList<MaterialResultRentDetailEntity>();
                    for (PicketageQuoteRentDetailEntity rent : rentDetailList) {
                        MaterialResultRentDetailEntity rentDetailEntity = new MaterialResultRentDetailEntity();
                        rentDetailEntity.setPid(result.getId());
                        rentDetailEntity.setId(IdWorker.getId());
                        rentDetailEntity.setSourceId(rent.getId());
                        rentDetailEntity.setMaterialCategoryId(rent.getMaterialCategoryId());
                        rentDetailEntity.setMaterialCategoryName(rent.getMaterialCategoryName());
                        rentDetailEntity.setMaterialId(rent.getMaterialId());
                        rentDetailEntity.setMaterialName(rent.getMaterialName());
                        rentDetailEntity.setSpec(rent.getSpec());
                        rentDetailEntity.setUnit(rent.getUnit());
                        rentDetailEntity.setResidueNum(rent.getResidueNum());
                        rentDetailEntity.setReferPrice(rent.getReferPrice());
                        rentDetailEntity.setBidNum(rent.getBidNum());
                        rentDetailEntity.setBidPrice(rent.getBidPrice());
                        rentDetailEntity.setBidMny(rent.getBidMny());
                        rentDetailEntity.setRentTerm(rent.getRentTerm());
                        rentDetailEntity.setRentMode(rent.getRentMode());
                        rentDetailEntities.add(rentDetailEntity);
                    }
                    saveRentList.addAll(rentDetailEntities);
                }
                resultList.add(result);
            }
            if (CollectionUtils.isNotEmpty(savePurchaseList)) {
                this.resultPurchaseDetailService.saveOrUpdateBatch(savePurchaseList);
                logger.info("savePurchaseList--{}", (Object)JSONObject.toJSONString(savePurchaseList));
            }
            if (CollectionUtils.isNotEmpty(saveRentList)) {
                this.resultRentDetailService.saveOrUpdateBatch(saveRentList);
                logger.info("saveRentList--{}", (Object)JSONObject.toJSONString(saveRentList));
            }
            if (CollectionUtils.isNotEmpty(resultList)) {
                this.materialResultService.saveOrUpdateBatch(resultList);
                logger.info("materialResultData--{}", (Object)JSONObject.toJSONString(resultList));
            }
        }
        return resultList;
    }

    @Override
    public void sendMsg(Long id) throws Exception {
        MaterialPicketageEntity entity = (MaterialPicketageEntity)((Object)super.selectById((Serializable)id));
        QueryWrapper quoteWrapper = new QueryWrapper();
        quoteWrapper.eq((Object)"picketage_id", (Object)entity.getId());
        quoteWrapper.eq((Object)"bid_flag", (Object)1);
        List quoteList = this.quoteService.list((Wrapper)quoteWrapper);
        for (MaterialPicketageQuoteEntity quote : quoteList) {
            if (!StringUtils.isNotEmpty((String)quote.getLegal()) || !StringUtils.isNotEmpty((String)quote.getTelephone())) continue;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            this.sendVerifyCode(quote.getTelephone(), quote.getLegal(), sdf.format(quote.getQuoteTime()), entity.getName(), decimalFormat.format(quote.getBidMny()), null);
        }
    }

    public void sendVerifyCode(String phone, String userName, String publishTime, String title, String amount, String templateCode) throws Exception {
        Assert.hasText((String)phone, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)phone);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userName", userName);
        params.put("publishTime", publishTime);
        params.put("title", title);
        params.put("amount", amount);
        messageParam.put("params", params);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)templateCode)) {
            messageParam.put(TEMPLATE_CODE, (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put(TEMPLATE_CODE, (Object)templateCode);
        }
        logger.info("\u53d1\u9001\u77ed\u4fe1\u53c2\u6570\uff1a[{}]", (Object)messageParam);
        String messageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
        logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u77ed\u4fe1\u7ed3\u679c\uff1a[{}]", (Object)phone, (Object)responseStr);
        CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
        }
    }
}

