/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.mapper.MaterialQuoteMapper;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialQuotePurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteRentDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="materialQuoteService")
public class MaterialQuoteServiceImpl
extends BaseServiceImpl<MaterialQuoteMapper, MaterialQuoteEntity>
implements IMaterialQuoteService {
    private static final Logger logger = LoggerFactory.getLogger(MaterialQuoteServiceImpl.class);
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_195335074";
    private static final String TEMPLATE_CODE = "templateCode";
    private static final String VERIFY_CODE_ERROR = "\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25\uff01";
    @Resource
    private IMaterialInquiryService materialInquiryService;
    @Resource
    private EnvironmentTools environmentTools;
    @Resource
    private IMaterialQuotePurchaseDetailService purchaseDetailService;
    @Resource
    private IMaterialQuoteRentDetailService rentDetailService;

    @Override
    public void checkQuoteEndDate(Long inquiryId) {
        Assert.notNull((Object)inquiryId, (String)"\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialInquiryEntity materialInquiryEntity = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(inquiryId));
        if (materialInquiryEntity == null) {
            throw new BusinessException("\u8be5\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728\uff01");
        }
        boolean after = new Date().after(materialInquiryEntity.getQuoteEndDate());
        if (after) {
            throw new BusinessException("\u5f53\u524d\u65f6\u95f4\u5df2\u8d85\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff01");
        }
    }

    @Override
    public void checkViewAuthority(Long inquiryId, String phoneNumber) {
        Assert.notNull((Object)inquiryId, (String)"\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialInquiryEntity materialInquiryEntity = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(inquiryId));
        if (materialInquiryEntity == null) {
            throw new BusinessException("\u8be5\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (materialInquiryEntity.getViewAuthority() == 1) {
            materialInquiryEntity.getMaterialInquirySupplierList().stream().filter(materialInquirySupplierEntity -> phoneNumber.equals(materialInquirySupplierEntity.getTelephone())).findFirst().orElseThrow(() -> new BusinessException("\u8be5\u624b\u673a\u53f7\u65e0\u6743\u9650\u8bf7\u5207\u6362\u5176\u4ed6\u53f7\u7801\u91cd\u8bd5\uff01"));
        }
    }

    @Override
    public void checkQuotationAuthority(Long inquiryId, String phoneNumber) {
        Assert.notNull((Object)inquiryId, (String)"\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialInquiryEntity materialInquiryEntity = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(inquiryId));
        if (materialInquiryEntity == null) {
            throw new BusinessException("\u8be5\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (materialInquiryEntity.getQuotationAuthority() == 1) {
            materialInquiryEntity.getMaterialInquirySupplierList().stream().filter(materialInquirySupplierEntity -> phoneNumber.equals(materialInquirySupplierEntity.getTelephone())).findFirst().orElseThrow(() -> new BusinessException("\u8be5\u624b\u673a\u53f7\u65e0\u62a5\u4ef7\u6743\u9650\uff0c\u8bf7\u5207\u6362\u767b\u5f55\u624b\u673a\u53f7"));
        }
    }

    public void sendVerifyCode(String phoneNumber, String templateCode) throws Exception {
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)phoneNumber);
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            messageParam.put(TEMPLATE_CODE, (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put(TEMPLATE_CODE, (Object)templateCode);
        }
        String messageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
        logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a[{}]", (Object)phoneNumber, (Object)responseStr);
        CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
        }
    }

    public void checkVerifyCode(String phoneNumber, String validate, String templateCode) {
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)validate, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            jsonObject.put(TEMPLATE_CODE, (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            jsonObject.put(TEMPLATE_CODE, (Object)templateCode);
        }
        jsonObject.put("phone", (Object)phoneNumber);
        jsonObject.put("validate", (Object)validate);
        String checkMessageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/checkMessage";
        HttpResponse response = HttpUtil.createPost((String)checkMessageUrl).body(jsonObject.toJSONString()).execute();
        if (!response.isOk()) {
            throw new BusinessException(VERIFY_CODE_ERROR);
        }
        String responseStr = response.body();
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            throw new BusinessException(VERIFY_CODE_ERROR);
        }
        CommonResponse checkResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (0 != checkResponse.getCode()) {
            logger.info("\u6821\u9a8c\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)checkResponse.getMsg());
            throw new BusinessException(checkResponse.getMsg());
        }
    }

    @Override
    public void fetchVerifyCode(Long inquiryId, String phoneNumber) throws Exception {
        Assert.notNull((Object)inquiryId, (String)"\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialInquiryEntity materialInquiryEntity = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(inquiryId));
        if (materialInquiryEntity == null) {
            throw new BusinessException("\u8be5\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728\uff01");
        }
        this.sendVerifyCode(phoneNumber, null);
    }

    @Override
    public void login(String phoneNumber, String validate) {
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)validate, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.checkVerifyCode(phoneNumber, validate, null);
    }

    @Override
    public void withdraw(Long id) {
        Assert.notNull((Object)id, (String)"\u62a5\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialQuoteEntity entity = (MaterialQuoteEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u8be5\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728\uff01");
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)entity.getInquiryId())).eq(MaterialInquiryEntity::getInquiryState, (Object)InquiryStateEnum.WIN_STATE.getCode());
        MaterialInquiryEntity materialInquiryEntity = (MaterialInquiryEntity)((Object)this.materialInquiryService.getOne((Wrapper)wrapper));
        if (materialInquiryEntity != null) {
            throw new BusinessException("\u8be5\u8be2\u4ef7\u5df2\u7ed3\u675f\uff0c\u62a5\u4ef7\u8bb0\u5f55\u4e0d\u53ef\u6536\u56de\uff01");
        }
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setQuoteTime(null);
        super.updateById((Object)entity);
    }

    @Override
    public void changeStatus(Long id, Integer billState) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)billState, (String)"\u5355\u636e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MaterialQuoteEntity entity = (MaterialQuoteEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u8be5\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728\uff01");
        }
        entity.setBillState(billState);
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(billState)) {
            entity.setQuoteTime(new Date());
        } else {
            entity.setQuoteTime(null);
        }
        super.updateById((Object)entity);
    }

    @Override
    public MaterialQuoteVO recentQuote(String phoneNumber) {
        Assert.hasText((String)phoneNumber, (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MaterialQuoteEntity::getQuotePhone, (Object)phoneNumber)).orderByDesc(MaterialQuoteEntity::getQuoteTime)).last("limit 1");
        List list = super.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (MaterialQuoteVO)BeanMapper.map(list.get(0), MaterialQuoteVO.class);
    }
}

