package com.ejianc.business.bidprice.material.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bidprice.material.bean.*;
import com.ejianc.business.bidprice.material.service.IMaterialResultPurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialResultRentDetailService;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.bidprice.material.vo.MaterialResultPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialResultRentDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.bidprice.material.service.IMaterialResultService;
import com.ejianc.business.bidprice.material.vo.MaterialResultVO;

/**
 * 材料定标结果
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialResult")
@Api(value = "材料定标结果", tags = {"材料定标结果"})
public class MaterialResultController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    private static final String BILL_CODE = "MATERIAL_RESULT";

    @Autowired
    private IMaterialResultService service;

    @Autowired
    private IMaterialResultPurchaseDetailService materialResultPurchaseDetailService;

    @Autowired
    private IMaterialResultRentDetailService materialResultRentDetailService;

    @Autowired
    private SessionManager sessionManager;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialResultVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody MaterialResultVO saveOrUpdateVO) {
        MaterialResultEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialResultEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        MaterialResultVO vo = BeanMapper.map(entity, MaterialResultVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询中标供应商列表")
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialResultVO>> querySupplierList(@RequestParam Long picketageId) {
        LambdaQueryWrapper<MaterialResultEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(MaterialResultEntity::getPicketageId, picketageId);
        List<MaterialResultEntity> list = service.list(wrapper);
        List<MaterialResultVO> materialResultVOS = BeanMapper.mapList(list, MaterialResultVO.class);
        return CommonResponse.success("查询中标供应商列表！", materialResultVOS);
    }



    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialResultVO> queryDetail(@RequestParam Long id) {
        MaterialResultEntity entity = service.selectById(id);
        MaterialResultVO vo = BeanMapper.map(entity, MaterialResultVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetailByCon", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialResultVO> queryDetailByCon(@RequestBody MaterialResultVO materialResultVO) {
        LambdaQueryWrapper<MaterialResultEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(MaterialResultEntity::getPicketageId, materialResultVO.getPicketageId());
        lambdaQueryWrapper.eq(MaterialResultEntity::getSupplierId, materialResultVO.getSupplierId());
        List<MaterialResultEntity> list = service.list(lambdaQueryWrapper);
        MaterialResultVO vo = null;
        if (CollectionUtils.isNotEmpty(list)) {
            vo = BeanMapper.map(list.get(0), MaterialResultVO.class);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询中标结果列表通过定标单")
    @RequestMapping(value = "/queryListByPicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialResultVO>> queryListByPicketage(@RequestBody MaterialPicketageVO materialPicketageVO) {
        LambdaQueryWrapper<MaterialResultEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(MaterialResultEntity::getPicketageId, materialPicketageVO.getId());
        List<MaterialResultEntity> list = service.list(lambdaQueryWrapper);
        return CommonResponse.success("查询详情数据成功！", BeanMapper.mapList(list, MaterialResultVO.class));
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialResultVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialResultVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialResultVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialResultVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<MaterialResultEntity> page = service.queryPage(param, false);
        IPage<MaterialResultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialResultVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialResultEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialResult-export.xlsx", beans, response);
    }



    @RequestMapping(value = "/referTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                               @RequestParam String condition
    ) {
        if (org.apache.commons.lang.StringUtils.isEmpty(condition) || !condition.contains("orgId")) {
            throw new BusinessException("查询参数不正确！");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = conditionJson.getLong("orgId");
        Long pricingType = conditionJson.getLong("pricingType");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        if (null != pricingType) {
            queryParam.getParams().put("pricingType", new Parameter(QueryParam.EQ, pricingType));
        }
        queryParam.setOrderMap(orderMap);
        /** 数据隔离 参数组织orgId本下 */
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialResultEntity> dataList = service.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for (MaterialResultEntity entity : dataList) {
            QueryParam querySubResParams = new QueryParam();
            querySubResParams.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
            List<MaterialResultPurchaseDetailEntity> materialResultPurchaseDetailEntities = materialResultPurchaseDetailService.queryList(querySubResParams);
            if (CollectionUtils.isEmpty(materialResultPurchaseDetailEntities)){
                continue;
            }
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getPurchaseSubject());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if(CollectionUtils.isNotEmpty(resultMapList)){
            map = new HashMap<>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "全部");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }

        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     *  参照询价定标单----------树表  表数据
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param condition
     * @param relyNode
     * @param searchText
     * @param searchObject
     * @return
     */

    @RequestMapping(value = "/refMaterialResultPurchaseDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialResultPurchaseDetailVO>> refMaterialResultPurchaseDetail(@RequestParam Integer pageNumber,
                                                                           @RequestParam Integer pageSize,
                                                                           @RequestParam(required = false) String relyCondition,
                                                                           @RequestParam(required = false) String condition,
                                                                           @RequestParam(required = false) String relyNode,
                                                                           @RequestParam(required = false) String searchText,
                                                                           @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("spec");
        queryParam.getFuzzyFields().add("unit");
        queryParam.getFuzzyFields().add("materialCategoryName");
        Map<String, Parameter> param = queryParam.getParams();

        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = null != conditionJson.getLong("orgId") ? conditionJson.getLong("orgId") : InvocationInfoProxy.getOrgId();
        Long projectId = conditionJson.getLong("projectId");
        //是否查询全部询价单合计
        boolean queryAllFlag = false;
        String pid = null;
        if (org.apache.commons.lang.StringUtils.isNotEmpty(relyCondition)) {
             pid = relyCondition.split("=")[1];
            if(!"000001".equals(pid)){
                param.put("pid", new Parameter(QueryParam.EQ, pid));
            } else {
                queryAllFlag = true;
            }
        } else {
            //移动端查询逻辑
            param.put("projectId", new Parameter(QueryParam.EQ, projectId));
            queryAllFlag = true;
        }

        if (org.apache.commons.lang.StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }

        IPage<MaterialResultPurchaseDetailEntity> list = null;
        Map<Long,Long> supIdMap = new HashMap();
        Map<Long,String> supNameMap = new HashMap();
        if (queryAllFlag) {
                queryParam.getParams().put("orgId",new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                List<MaterialResultEntity> materialResultEntities = service.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(materialResultEntities)){
                    List<Long> ids = materialResultEntities.stream().map(MaterialResultEntity::getId).collect(Collectors.toList());
                    materialResultEntities.forEach(v->{
                        supIdMap.put(v.getId(),v.getSupplierId());
                        supNameMap.put(v.getId(),v.getSupplierName());
                    });
                    QueryParam SubParam = new QueryParam();
                    SubParam.getParams().put("pid", new Parameter(QueryParam.IN, ids));
                    SubParam.setPageIndex(pageNumber);
                    SubParam.setPageSize(pageSize);
                    list=materialResultPurchaseDetailService.queryPage(SubParam);
                }
            } else {
                list = materialResultPurchaseDetailService.queryPage(queryParam);
                if (StringUtils.isNotBlank(pid)) {
                    MaterialResultEntity materialResultEntity = service.selectById(pid);
                    supIdMap.put(materialResultEntity.getId(),materialResultEntity.getSupplierId());
                    supNameMap.put(materialResultEntity.getId(),materialResultEntity.getSupplierName());
                }
            }
        if (null==list){
            return CommonResponse.success("查询数表参照成功");
        }
        List<MaterialResultPurchaseDetailVO> listVo=BeanMapper.mapList(list.getRecords(), MaterialResultPurchaseDetailVO.class);
        Map<Long, MaterialResultPurchaseDetailVO> collect = listVo.stream().collect(Collectors.toMap(MaterialResultPurchaseDetailVO::getMaterialId, e -> e, (item1, item2) -> item1));
        List<Long> materialIds =  collect.keySet().stream().collect(Collectors.toList());
        List<Long> pids = listVo.stream().filter(item -> null != item.getPid()).map(MaterialResultPurchaseDetailVO::getPid).collect(Collectors.toList());
        LambdaQueryWrapper<MaterialResultEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.in(MaterialResultEntity::getId,pids);
        List<MaterialResultEntity> useApplyEntityList = service.list(lambdaQueryWrapper);
        Map<Long, String> billCodeMap = useApplyEntityList.stream().collect(Collectors.toMap(MaterialResultEntity::getId, MaterialResultEntity::getBillCode));
        for (MaterialResultPurchaseDetailVO detailVO : listVo) {
            detailVO.setBillCode(billCodeMap.get(detailVO.getPid()));
        }

        if (CollectionUtils.isNotEmpty(materialIds)){
            CommonResponse<List<MaterialVO>> queryMaterialResponse = materialApi.queryMaterialByIds(materialIds);
            if(queryMaterialResponse.isSuccess()) {
                if (CollectionUtils.isNotEmpty(queryMaterialResponse.getData())){
                    for (MaterialResultPurchaseDetailVO data:listVo){
                        data.setSupplierId(supIdMap.get(data.getPid()));
                        data.setSupplierName(supNameMap.get(data.getPid()));
                        for (MaterialVO vo:queryMaterialResponse.getData()){
                            if(data.getMaterialId().equals(vo.getId())){
                                data.setMaterialCode(vo.getCode());
                            }
                        }
                    }
                }
            }else{
                throw new BusinessException("网络异常， 获取物资编码失败");
            }
        }
        IPage<MaterialResultPurchaseDetailVO> pageData = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
        pageData.setTotal(list.getTotal());
        pageData.setPages(list.getPages());
        pageData.setRecords(listVo);
        return CommonResponse.success("查询数表参照成功", pageData);
    }

    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialResultData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialResultVO>> refMaterialResultData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("purchaseSubject");
        param.getFuzzyFields().add("purchaseTypeName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

            if (_con.containsKey("orgId")) {
                param.getComplexParams().add(getPageQueryParam(_con.getLong("orgId")));
            }
            if (_con.containsKey("supplierId") && _con.getLong("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, _con.getLong("supplierId")));
            }
            if (_con.containsKey("pricingType")) {
                param.getParams().put("pricingType", new Parameter(QueryParam.EQ, _con.getLong("pricingType")));
            }
            if (_con.containsKey("purchaseType")) {
                param.getParams().put("purchaseType", new Parameter(QueryParam.EQ, _con.getInteger("purchaseType")));
            }

        }

        IPage<MaterialResultEntity> page = service.queryPage(param, false);
        IPage<MaterialResultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialResultVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childOrgResp = iOrgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = iOrgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);

        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, 2));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaterialResultPurchaseDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialResultPurchaseDetailVO>> refMaterialResultPurchaseDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                                     String condition,
                                                                                                     String searchObject,
                                                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialName");
        param.getFuzzyFields().add("materialTypeName");
        param.getFuzzyFields().add("model");
        param.getFuzzyFields().add("unit");
        MaterialResultEntity entity = new MaterialResultEntity();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (!_con.containsKey("pid")) {
                return CommonResponse.error("查询条件定标结果单Id【pid】不能为空");
            }
            param.getParams().put("pid", new Parameter(QueryParam.EQ, _con.getLong("pid")));
            entity = service.selectById(_con.getLong("pid"));
        }

        IPage<MaterialResultPurchaseDetailEntity> page = materialResultPurchaseDetailService.queryPage(param, false);
        IPage<MaterialResultPurchaseDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MaterialResultPurchaseDetailVO> list = BeanMapper.mapList(page.getRecords(), MaterialResultPurchaseDetailVO.class);
        Map<Long, MaterialResultPurchaseDetailVO> collect = list.stream().collect(Collectors.toMap(MaterialResultPurchaseDetailVO::getMaterialId, e -> e, (item1, item2) -> item1));
        List<Long> materialIds =  collect.keySet().stream().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(materialIds)){
            CommonResponse<List<MaterialVO>> queryMaterialResponse = materialApi.queryMaterialByIds(materialIds);
            if(queryMaterialResponse.isSuccess()) {
                if (CollectionUtils.isNotEmpty(queryMaterialResponse.getData())){
                    for (MaterialResultPurchaseDetailVO data:list){
                        data.setBillCode(entity.getBillCode());
                        for (MaterialVO vo:queryMaterialResponse.getData()){
                            if(data.getMaterialId().equals(vo.getId())){
                                data.setMaterialCode(vo.getCode());
                            }
                        }
                    }
                }
            }else{
                throw new BusinessException("网络异常， 获取物资编码失败");
            }
        }
        pageData.setRecords(list);

        page.setTotal(page.getTotal());
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaterialResultRentDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialResultRentDetailVO>> refMaterialResultRentDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                             String condition,
                                                                                             String searchObject,
                                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        param.getFuzzyFields().add("materialName");
       // param.getFuzzyFields().add("materialTypeName");
        //param.getFuzzyFields().add("model");
        param.getFuzzyFields().add("unit");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

            if (!_con.containsKey("pid")) {
                return CommonResponse.error("查询条件定标结果单Id【pid】不能为空");
            }
            param.getParams().put("pid", new Parameter(QueryParam.EQ, _con.getLong("pid")));

        }

        IPage<MaterialResultRentDetailEntity> page = materialResultRentDetailService.queryPage(param, false);
        IPage<MaterialResultRentDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialResultRentDetailVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
