package com.ejianc.business.desktop.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.desktop.hystrix.AllProjectSetPoolHystrix;

import com.ejianc.business.desktop.vo.ProjectPoolSetVO;
import com.ejianc.business.desktop.vo.WeixineeUserVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 *
 *
 * bpm数据库消息查询接口
 * @author Jiang
 *
 */
@FeignClient(name= "ejc-bpmdesktop-web", url="${common.env.feign-client-url}", path="ejc-bpmdesktop-web", fallback = AllProjectSetPoolHystrix.class)
public interface IAllProjectSetPoolApi {


	/**
	 * @Description 分页查询所有项目信息
	 * @Return void
	 */
	@GetMapping(value = "/api/projectSetPool/queryProjectSetData")
	CommonResponse<List<ProjectPoolSetVO>> queryProjectSetData(@RequestParam(defaultValue = "1") int pageNumber,
															   @RequestParam(defaultValue = "10") int pageSize,
															   @RequestParam(required = false) String relyCondition,
															   @RequestParam(required=false) String condition,
															   @RequestParam(required=false) String searchObject,
															   @RequestParam(required=false) String searchText);

	/**
	 * @Description
	 * @Return void
	 */
	@GetMapping(value = "/api/projectSetPool/queryUserByWeixineeId")
	CommonResponse<WeixineeUserVO> queryUserByWeixineeId(@RequestParam(value = "weixineeId",required=true) String weixineeId);
}
