package com.ejianc.business.desktop.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.desktop.hystrix.SalaryReportHystrix;
import com.ejianc.business.desktop.hystrix.ShareCategoryHystrix;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.business.desktop.vo.SalaryReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 *
 *
 * @author
 *
 */
@FeignClient(name= "ejc-bpmdesktop-web", url="${common.env.feign-client-url}", path="ejc-bpmdesktop-web", fallback = SalaryReportHystrix.class)
public interface ISalaryReportApi {

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/report/queryList", method = RequestMethod.POST)
    CommonResponse<List<SalaryReportVO>> queryList(@RequestBody QueryParam param);
}
