package com.ejianc.business.desktop.mapper;



import com.ejianc.business.desktop.bean.ProjectSetPoolEntity;
import com.ejianc.business.desktop.vo.idmUser.SalaryUserVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserRefVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

@Mapper
public interface UserMapper extends BaseCrudMapper<ProjectSetPoolEntity> {
    List<SalaryUserVO> syncUserDataByTime(String time);

    List<String> getOrgCodeList(Long orgId);

    @Select("select * from ejc_idm_org where id = #{orgId}")
    OrgVO queryDetail(Long orgId);

    long countRef(Map<String, Object> params);

    List<UserRefVO> queryListRef(Map<String, Object> params);

    List<UserVO> getWeixineeIdList();

    UserVO getUserByWeixineeId(String weixineeId);
}
