package com.ejianc.business.desktop.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.bean.SalaryReportEntity;
import com.ejianc.business.desktop.mapper.ReportMapper;
import com.ejianc.business.desktop.mapper.TaskinstMapper;
import com.ejianc.business.desktop.service.IReportService;
import com.ejianc.business.desktop.service.ITaskinstService;
import com.ejianc.business.desktop.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 流程主题门户接口
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("report")
public class ReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IReportService service;
    @Autowired
    private ReportMapper mapper;
    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description
     * @param
     */
    @RequestMapping(value = "/queryData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReportDataVO> queryData(@RequestBody QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        ReportDataVO reportDataVOS = mapper.queryData(wrapper);
        return CommonResponse.success("查询详情数据成功！",reportDataVOS);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SalaryReportVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SalaryReportEntity> page = service.queryPage(param,false);

//        IPage<SalaryReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalaryReportVO.class));

        return CommonResponse.success("查询列表数据成功！",BeanMapper.mapList(page.getRecords(), SalaryReportVO.class));
    }
}
