package com.ejianc.business.desktop.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.bean.ProjectSetPoolEntity;
import com.ejianc.business.desktop.service.IProjectSetService;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.business.desktop.vo.ProjectPoolSetVO;
import com.ejianc.business.desktop.vo.TaskinstVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/category")
public class CategoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IProjectSetService projectSetService;


    /**
     * @Description
     * @param
     */
    @RequestMapping(value = "/query", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CategoryVO>> query(@RequestParam String[] codes) {
        List<String> query = Arrays.asList(codes);
        //获取当前用户的id
        List<CategoryVO> categoryVOS = new ArrayList<>();

        categoryVOS.addAll(projectSetService.queryCategory(query));

        return CommonResponse.success("查询详情数据成功！",categoryVOS);
    }




}

