/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.desktop.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.mapper.TaskinstMapper;
import com.ejianc.business.desktop.service.ITaskinstService;
import com.ejianc.business.desktop.vo.BpmVariableVO;
import com.ejianc.business.desktop.vo.TaskinstVO;
import com.ejianc.business.desktop.vo.UserInfoVO;
import com.ejianc.business.promaterial.contract.api.IPromaterialContractApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"taskinst"})
public class TaskinstController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITaskinstService service;
    @Autowired
    private IPromaterialContractApi contractApi;
    @Autowired
    private TaskinstMapper mapper;
    @Autowired
    private SessionManager sessionManager;

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/queryYearUser"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearUser(@RequestBody QueryParam param) {
        String searchText;
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort")) {
            timeSort = (String)param.getOrderMap().get("timeSort");
        }
        String count = null;
        if (null != param.getOrderMap().get("count")) {
            count = (String)param.getOrderMap().get("count");
        }
        String sumTime = null;
        if (null != param.getOrderMap().get("sumTime")) {
            sumTime = (String)param.getOrderMap().get("sumTime");
        }
        String orgCode = null;
        if (null != param.getOrderMap().get("orgCode")) {
            orgCode = (String)param.getOrderMap().get("orgCode");
        }
        if ((searchText = param.getSearchText()) != null) {
            searchText = "%" + searchText + "%";
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();
        Long orgId = null;
        if (null != param.getParams().get("orgId")) {
            orgId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("orgId")).getValue()));
            userId = null;
        }
        Long deptId = null;
        if (null != param.getParams().get("deptId")) {
            deptId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("deptId")).getValue()));
        }
        if (null != param.getParams().get("isAllFlag")) {
            Long deptId1 = userContextCache.getDeptId();
            this.logger.info("orgId:{},deptId1:{}", (Object)orgId, (Object)deptId1);
            if (deptId1 != null) {
                if (deptId1 == 1502571152969568257L) {
                    userId = null;
                } else {
                    deptId = deptId1;
                    userId = null;
                }
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<TaskinstVO> vo = this.service.queryLastYearUser((Page<TaskinstVO>)page, userId, orgId, deptId, start, end, timeSort, count, sumTime, orgCode, searchText);
        vo.stream().forEach(taskinstVO -> {
            if (taskinstVO.getAvgTime() != null) {
                taskinstVO.setAvgTime(Double.valueOf(taskinstVO.getAvgTime() / 3600000.0));
            } else {
                taskinstVO.setAvgTime(Double.valueOf(0.0));
            }
            if (taskinstVO.getSumTime() != null) {
                taskinstVO.setSumTime(Double.valueOf(taskinstVO.getSumTime() / 3600000.0));
            } else {
                taskinstVO.setSumTime(Double.valueOf(0.0));
            }
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryUserDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryUserDetail(@RequestBody QueryParam param) {
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Long userId = 0L;
        if (null != param.getParams().get("userId")) {
            userId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("userId")).getValue()));
        }
        String stateFlag = null;
        if (null != param.getParams().get("stateFlag")) {
            stateFlag = String.valueOf(((Parameter)param.getParams().get("stateFlag")).getValue());
        }
        List<TaskinstVO> vo = this.service.queryUserDetail((Page<TaskinstVO>)page, userId, start, end, stateFlag);
        vo.stream().forEach(taskinstVO -> {
            if (taskinstVO.getDuration() != null) {
                taskinstVO.setDurationTime(Double.valueOf((double)taskinstVO.getDuration().longValue() / 3600000.0));
            } else {
                taskinstVO.setDurationTime(Double.valueOf(0.0));
            }
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryYearOrgUnder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearOrgUnder(@RequestBody QueryParam param) {
        String searchText;
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort")) {
            timeSort = (String)param.getOrderMap().get("timeSort");
        }
        String count = null;
        if (null != param.getOrderMap().get("count")) {
            count = (String)param.getOrderMap().get("count");
        }
        String sumTime = null;
        if (null != param.getOrderMap().get("sumTime")) {
            sumTime = (String)param.getOrderMap().get("sumTime");
        }
        String orgCode = null;
        if (null != param.getOrderMap().get("orgCode")) {
            orgCode = (String)param.getOrderMap().get("orgCode");
        }
        if ((searchText = param.getSearchText()) != null) {
            searchText = "%" + searchText + "%";
        }
        Long deptId = userContextCache.getDeptId();
        String glcFlag = null;
        if (deptId != null && deptId == 1502571152969568257L) {
            deptId = null;
            glcFlag = "true";
        }
        List<Object> vo = new ArrayList();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Long orgId = InvocationInfoProxy.getOrgId();
        String groupFlag = "true";
        if (null != param.getParams().get("orgId")) {
            groupFlag = null;
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List<Long> collect = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        vo = this.service.queryYearOrgUnder((Page<TaskinstVO>)page, collect, start, end, timeSort, deptId, groupFlag, count, sumTime, orgCode, searchText, glcFlag);
        vo.stream().forEach(taskinstVO -> {
            taskinstVO.setAvgTime(Double.valueOf(taskinstVO.getAvgTime() / 3600000.0));
            taskinstVO.setSumTime(Double.valueOf(taskinstVO.getSumTime() / 3600000.0));
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryYearOrg"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearOrg(@RequestBody QueryParam param) {
        Long deptId;
        String searchText;
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort")) {
            timeSort = (String)param.getOrderMap().get("timeSort");
        }
        String count = null;
        if (null != param.getOrderMap().get("count")) {
            count = (String)param.getOrderMap().get("count");
        }
        String sumTime = null;
        if (null != param.getOrderMap().get("sumTime")) {
            sumTime = (String)param.getOrderMap().get("sumTime");
        }
        String orgCode = null;
        if (null != param.getOrderMap().get("orgCode")) {
            orgCode = (String)param.getOrderMap().get("orgCode");
        }
        if ((searchText = param.getSearchText()) != null) {
            searchText = "%" + searchText + "%";
        }
        if ((deptId = userContextCache.getDeptId()) != null && deptId == 1502571152969568257L) {
            deptId = null;
        }
        List<Object> vo = new ArrayList();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Long orgId = InvocationInfoProxy.getOrgId();
        String groupFlag = "true";
        if (null != param.getParams().get("orgId")) {
            groupFlag = null;
        }
        if (null != param.getParams().get("org")) {
            orgId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("org")).getValue()));
            deptId = null;
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List<Long> collect = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        vo = this.service.queryYearOrg((Page<TaskinstVO>)page, collect, start, end, timeSort, deptId, groupFlag, count, sumTime, orgCode, searchText);
        vo.stream().forEach(taskinstVO -> {
            taskinstVO.setAvgTime(Double.valueOf(taskinstVO.getAvgTime() / 3600000.0));
            taskinstVO.setSumTime(Double.valueOf(taskinstVO.getSumTime() / 3600000.0));
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryTolalInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryTolalInfo(@RequestBody QueryParam param) {
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Long orgId = null;
        if (null != param.getParams().get("orgId")) {
            orgId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("orgId")).getValue()));
        }
        Long deptId = null;
        if (null != param.getParams().get("deptId")) {
            deptId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("deptId")).getValue()));
        }
        List<TaskinstVO> vo = this.service.queryTolalInfo(orgId, deptId, start, end);
        JSONObject res = new JSONObject();
        if (vo != null && vo.size() > 0) {
            String avgTimeTotal = String.format("%.2f", vo.get(0).getAvgTime() / 3600000.0);
            String sumTimeTotal = String.format("%.2f", vo.get(0).getSumTime() / 3600000.0);
            res.put("sumTimeTotal", (Object)sumTimeTotal);
            res.put("countTotal", (Object)vo.get(0).getCount());
            res.put("avgTimeTotal", (Object)avgTimeTotal);
        } else {
            res.put("sumTimeTotal", (Object)0);
            res.put("countTotal", (Object)0);
            res.put("avgTimeTotal", (Object)0);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryYearBill"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearBill(@RequestBody QueryParam param) {
        String searchText;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billName");
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort")) {
            timeSort = (String)param.getOrderMap().get("timeSort");
        }
        String count = null;
        if (null != param.getOrderMap().get("count")) {
            count = (String)param.getOrderMap().get("count");
        }
        String sumTime = null;
        if (null != param.getOrderMap().get("sumTime")) {
            sumTime = (String)param.getOrderMap().get("sumTime");
        }
        String orgCode = null;
        if (null != param.getOrderMap().get("orgCode")) {
            orgCode = (String)param.getOrderMap().get("orgCode");
        }
        if ((searchText = param.getSearchText()) != null) {
            searchText = "'%" + searchText + "%'";
        }
        String stateFlag = null;
        if (null != param.getParams().get("stateFlag")) {
            stateFlag = String.valueOf(((Parameter)param.getParams().get("stateFlag")).getValue());
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List<Long> collect = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<TaskinstVO> vo = this.service.queryYearBill((Page<TaskinstVO>)page, "", start, end, timeSort, stateFlag, collect, searchText);
        vo.stream().forEach(taskinstVO -> {
            if (taskinstVO.getAvgTime() != null) {
                taskinstVO.setAvgTime(Double.valueOf(taskinstVO.getAvgTime() / 3600000.0));
            } else {
                taskinstVO.setAvgTime(Double.valueOf(0.0));
            }
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryYearBillDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearBillDetail(@RequestBody QueryParam param) {
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort")) {
            timeSort = (String)param.getOrderMap().get("timeSort");
        }
        String billType = null;
        if (null != param.getParams().get("billType")) {
            billType = String.valueOf(((Parameter)param.getParams().get("billType")).getValue());
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<TaskinstVO> vo = this.service.queryYearBillDetail((Page<TaskinstVO>)page, "", start, end, timeSort, billType);
        vo.stream().forEach(taskinstVO -> {
            if (taskinstVO.getDurationTime() != null) {
                taskinstVO.setDurationTime(Double.valueOf(taskinstVO.getDurationTime() / 3600000.0));
            } else {
                taskinstVO.setDurationTime(Double.valueOf(0.0));
            }
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryYearBillUserDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearBillUserDetail(@RequestBody QueryParam param) {
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort")) {
            timeSort = (String)param.getOrderMap().get("timeSort");
        }
        String billType = null;
        if (null != param.getParams().get("billType")) {
            billType = String.valueOf(((Parameter)param.getParams().get("billType")).getValue());
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<TaskinstVO> vo = this.service.queryYearBillUserDetail((Page<TaskinstVO>)page, "", start, end, timeSort, billType);
        vo.stream().forEach(taskinstVO -> {
            if (taskinstVO.getAvgTime() != null) {
                taskinstVO.setAvgTime(Double.valueOf(taskinstVO.getAvgTime() / 3600000.0));
            } else {
                taskinstVO.setAvgTime(Double.valueOf(0.0));
            }
            if (taskinstVO.getSumTime() != null) {
                taskinstVO.setSumTime(Double.valueOf(taskinstVO.getSumTime() / 3600000.0));
            } else {
                taskinstVO.setSumTime(Double.valueOf(0.0));
            }
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryYearOrgLimit5"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearOrgLimit5(@RequestBody QueryParam param) {
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort")) {
            timeSort = (String)param.getOrderMap().get("timeSort");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List<Long> collect = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<TaskinstVO> vo = this.service.queryYearOrgLimit5((Page<TaskinstVO>)page, collect, start, end, timeSort);
        vo.stream().forEach(taskinstVO -> {
            taskinstVO.setAvgTime(Double.valueOf(taskinstVO.getAvgTime() / 3600000.0));
            taskinstVO.setSumTime(Double.valueOf(taskinstVO.getSumTime() / 3600000.0));
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryYearUserInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<UserInfoVO>> queryYearUserInfo(@RequestBody QueryParam param) {
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String timeSort = "desc";
        if (null != param.getOrderMap().get("timeSort")) {
            timeSort = (String)param.getOrderMap().get("timeSort");
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();
        Long orgId = null;
        if (null != param.getParams().get("orgId")) {
            orgId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("orgId")).getValue()));
            userId = null;
        }
        Long deptId = null;
        if (null != param.getParams().get("deptId")) {
            deptId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("deptId")).getValue()));
        }
        if (null != param.getParams().get("isAllFlag")) {
            Long deptId1 = userContextCache.getDeptId();
            this.logger.info("orgId:{},deptId1:{}", (Object)orgId, (Object)deptId1);
            if (deptId1 != null) {
                if (deptId1 == 1502571152969568257L) {
                    userId = null;
                } else {
                    deptId = deptId1;
                    userId = null;
                }
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<TaskinstVO> vo = this.service.queryLastYearUser((Page<TaskinstVO>)page, userId, orgId, deptId, start, end, timeSort, null, null, null, null);
        vo.stream().forEach(taskinstVO -> {
            taskinstVO.setAvgTime(Double.valueOf(taskinstVO.getAvgTime() / 3600000.0));
            taskinstVO.setSumTime(Double.valueOf(taskinstVO.getSumTime() / 3600000.0));
        });
        ArrayList<UserInfoVO> userInfoVOS = new ArrayList<UserInfoVO>();
        TaskinstVO taskinstVO2 = vo.get(0);
        UserInfoVO userInfoVO = new UserInfoVO();
        UserInfoVO userInfoVO4 = new UserInfoVO();
        userInfoVO4.setNum(taskinstVO2.getCompleted());
        userInfoVO4.setMaterialCategoryName("\u5b8c\u6210");
        userInfoVO4.setAmount(taskinstVO2.getCompleted());
        userInfoVO4.setWeight(String.format("%.2f", (double)taskinstVO2.getCompleted().longValue() / (double)taskinstVO2.getCount().longValue() * 100.0));
        userInfoVO4.setMaterialUnitName("\u4e2a");
        userInfoVO4.setUserId(userId);
        userInfoVOS.add(userInfoVO4);
        userInfoVO.setNum(taskinstVO2.getCallback());
        userInfoVO.setMaterialCategoryName("\u53ec\u56de");
        userInfoVO.setAmount(taskinstVO2.getCallback());
        userInfoVO.setWeight(String.format("%.2f", (double)taskinstVO2.getCallback().longValue() / (double)taskinstVO2.getCount().longValue() * 100.0));
        userInfoVO.setMaterialUnitName("\u4e2a");
        userInfoVO.setUserId(userId);
        userInfoVOS.add(userInfoVO);
        UserInfoVO userInfoVO1 = new UserInfoVO();
        userInfoVO1.setNum(taskinstVO2.getReject());
        userInfoVO1.setMaterialCategoryName("\u9a73\u56de");
        userInfoVO1.setAmount(taskinstVO2.getReject());
        userInfoVO1.setWeight(String.format("%.2f", (double)taskinstVO2.getReject().longValue() / (double)taskinstVO2.getCount().longValue() * 100.0));
        userInfoVO1.setMaterialUnitName("\u4e2a");
        userInfoVO1.setUserId(userId);
        userInfoVOS.add(userInfoVO1);
        UserInfoVO userInfoVO2 = new UserInfoVO();
        userInfoVO2.setNum(taskinstVO2.getSuspend());
        userInfoVO2.setMaterialCategoryName("\u9a73\u56de\u4e0d\u4e2d\u6b62");
        userInfoVO2.setAmount(taskinstVO2.getSuspend());
        userInfoVO2.setWeight(String.format("%.2f", (double)taskinstVO2.getSuspend().longValue() / (double)taskinstVO2.getCount().longValue() * 100.0));
        userInfoVO2.setMaterialUnitName("\u4e2a");
        userInfoVO2.setUserId(userId);
        userInfoVOS.add(userInfoVO2);
        UserInfoVO userInfoVO3 = new UserInfoVO();
        userInfoVO3.setNum(taskinstVO2.getTotalStop());
        userInfoVO3.setMaterialCategoryName("\u7ec8\u6b62");
        userInfoVO3.setAmount(taskinstVO2.getTotalStop());
        userInfoVO3.setWeight(String.format("%.2f", (double)taskinstVO2.getTotalStop().longValue() / (double)taskinstVO2.getCount().longValue() * 100.0));
        userInfoVO3.setMaterialUnitName("\u4e2a");
        userInfoVO3.setUserId(userId);
        userInfoVOS.add(userInfoVO3);
        UserInfoVO userInfoVO5 = new UserInfoVO();
        userInfoVO5.setNum(taskinstVO2.getWithdraw());
        userInfoVO5.setMaterialCategoryName("\u5f03\u5ba1");
        userInfoVO5.setAmount(taskinstVO2.getWithdraw());
        userInfoVO5.setWeight(String.format("%.2f", (double)taskinstVO2.getWithdraw().longValue() / (double)taskinstVO2.getCount().longValue() * 100.0));
        userInfoVO5.setMaterialUnitName("\u4e2a");
        userInfoVO5.setUserId(userId);
        userInfoVOS.add(userInfoVO5);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", userInfoVOS);
    }

    @RequestMapping(value={"/queryTimeOut"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryTimeOut(@RequestBody QueryParam param) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        UserContext userContextCache = this.sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();
        Long orgId = userContextCache.getOrgId();
        if (null != param.getParams().get("orgId")) {
            orgId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("orgId")).getValue()));
        }
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List<Long> collect = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<TaskinstVO> vo = this.service.queryTimeOut((Page<TaskinstVO>)page, userId, null, null, "", collect);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryTimeOutDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryTimeOutDetail(@RequestBody QueryParam param) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        UserContext userContextCache = this.sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();
        if (null != param.getParams().get("userId")) {
            userId = Long.parseLong(String.valueOf(((Parameter)param.getParams().get("userId")).getValue()));
        }
        List<TaskinstVO> vo = this.service.queryTimeOutDetail((Page<TaskinstVO>)page, userId);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryRejectException"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryRejectException(@RequestBody QueryParam param) {
        Calendar date = Calendar.getInstance();
        Integer integer = date.get(1);
        String yearFlag = String.valueOf(((Parameter)param.getParams().get("yearFlag")).getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(1)) - 1;
        }
        String yearStart = integer + "-01-01 00:00:00";
        String yearEnd = integer + "-12-31 23:59:59";
        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(((Parameter)param.getParams().get("createTime")).getValue()).split(",");
            yearStart = createTimes[0] + " 00:00:00";
            yearEnd = createTimes[1] + " 23:59:59";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        UserContext userContextCache = this.sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();
        List<TaskinstVO> vo = this.service.queryRejectException((Page<TaskinstVO>)page, userId, start, end, "");
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryYearOrgList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UserInfoVO> queryYearOrgList(@RequestBody QueryParam param) {
        List<Long> lastMonthStartTime = TaskinstController.getLastMonthStartTime();
        List<Long> lastMonthEndTime = TaskinstController.getLastMonthEndTime();
        DateTimeFormatter ftf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter ftf1 = DateTimeFormatter.ofPattern("MM-dd");
        ArrayList<String> strings = new ArrayList<String>();
        ArrayList<Double> doubles = new ArrayList<Double>();
        for (int i = lastMonthStartTime.size() - 1; i >= 0; --i) {
            String startTimeStr = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(lastMonthStartTime.get(i)), ZoneId.systemDefault()));
            String endTimeStr = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(lastMonthEndTime.get(i)), ZoneId.systemDefault()));
            String startTimeStr1 = ftf1.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(lastMonthStartTime.get(i)), ZoneId.systemDefault()));
            String endTimeStr1 = ftf1.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(lastMonthEndTime.get(i)), ZoneId.systemDefault()));
            strings.add(startTimeStr1 + "-" + endTimeStr1);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date start = new Date();
            Date end = new Date();
            try {
                start = format.parse(startTimeStr);
                end = format.parse(endTimeStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            String timeSort = "desc";
            if (null != param.getOrderMap().get("timeSort")) {
                timeSort = (String)param.getOrderMap().get("timeSort");
            }
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            List<Long> collect = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            List<TaskinstVO> vo = this.service.queryYearOrgList((Page<TaskinstVO>)page, collect, start, end, timeSort, null);
            doubles.add(vo.get(0).getAvgTime());
        }
        String[] array = new String[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            array[i] = (String)strings.get(i);
        }
        Double[] array1 = new Double[doubles.size()];
        for (int i = 0; i < doubles.size(); ++i) {
            array1[i] = (Double)doubles.get(i);
        }
        UserInfoVO userInfoVO = new UserInfoVO();
        userInfoVO.setStrings1(array);
        userInfoVO.setDoubles1(array1);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)userInfoVO);
    }

    @RequestMapping(value={"/queryYearUserDesktop"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TaskinstVO> queryYearUserDesktop() {
        UserContext userContextCache = this.sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();
        TaskinstVO taskinstVO = this.mapper.queryYearUserDesktop(userId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)taskinstVO);
    }

    public static List<Long> getLastMonthStartTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        return longs;
    }

    public static List<Long> getLastMonthEndTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, 0);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        calendar.add(2, -1);
        longs.add(calendar.getTimeInMillis());
        return longs;
    }

    @RequestMapping(value={"/queryBpmdtailByBillcode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BpmVariableVO> queryBpmdtailByBillcode(@RequestParam Long billcode) {
        BpmVariableVO taskinstVO = this.mapper.queryBpmdtailByBillcode(billcode);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)taskinstVO);
    }

    @RequestMapping(value={"/queryBpmNumByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Integer> queryBpmNumByProjectId(@RequestParam Long projectId) {
        CommonResponse listCommonResponse = this.contractApi.queryContractByProjectId(projectId);
        if (!listCommonResponse.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
        }
        List list = (List)listCommonResponse.getData();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Integer i = this.mapper.queryBpmNumByProjetId(list);
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)i);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)0);
    }
}

