package com.ejianc.foundation.budgetmanage.api;

import java.util.List;

import com.ejianc.foundation.budgetmanage.hystrix.ConsdrawbudgetHystrix;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.framework.core.response.CommonResponse;

/**
 * 施工图预算rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-budgetmanage-web", url="${common.env.feign-client-url}", path="ejc-budgetmanage-web", fallback = ConsdrawbudgetHystrix.class)
public interface IConsdrawbudgetApi {

    /**
     * 根据项目id查询施工图预算
     *
     * @param projectId
     * @return
     */
	@GetMapping("/api/consdrawbudget/queryByProjectId")
	CommonResponse<ConsdrawbudgetVO> queryByProjectId(@RequestParam(value = "projectId") Long projectId);

}
