package com.ejianc.foundation.budgetmanage.api;

import com.ejianc.foundation.budgetmanage.hystrix.SubpackageHystrix;
import com.ejianc.foundation.budgetmanage.vo.SubpackageVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 分包施工图预算rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-budgetmanage-web", url="${common.env.feign-client-url}", path="ejc-budgetmanage-web", fallback = SubpackageHystrix.class)
public interface ISubpackageApi {

    /**
     * 根据项目id查询施工图预算
     *
     * @param contractId
     * @return
     */
	@GetMapping("/api/subpackage/queryByContractId")
	CommonResponse<SubpackageVO> queryByContractId(@RequestParam(value = "contractId") Long contractId);

}
