/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.service.IQuotaanalysisdetailService;
import com.ejianc.business.bedget.vo.QuotaanalysisVO;
import com.ejianc.business.bedget.vo.QuotaanalysisdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"quotaanalysisExport"})
public class ExporQuotaanalysisController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IQuotaanalysisdetailService quotaanalysisdetailService;

    @RequestMapping(value={"/downloadQuotaanalysis"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"quotaanalysis-import.xlsx", (String)"\u9650\u989d\u8bbe\u8ba1\u6307\u6807\u5206\u6790\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportQuotaanalysis"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<QuotaanalysisdetailVO> successList = new ArrayList<QuotaanalysisdetailVO>();
        ArrayList<QuotaanalysisdetailVO> errorList = new ArrayList<QuotaanalysisdetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                QuotaanalysisdetailVO quotaanalysisdetailVO = new QuotaanalysisdetailVO();
                quotaanalysisdetailVO.setId(IdWorker.getId());
                quotaanalysisdetailVO.setStorCode((String)datas.get(0));
                quotaanalysisdetailVO.setName((String)datas.get(1));
                quotaanalysisdetailVO.setUnit((String)datas.get(2));
                quotaanalysisdetailVO.setTenderProjectNumber(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new Double((String)datas.get(3)) : null);
                quotaanalysisdetailVO.setBuildArea(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new Double((String)datas.get(4)) : null);
                quotaanalysisdetailVO.setTenderTarget(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                quotaanalysisdetailVO.setNormTarget(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                quotaanalysisdetailVO.setMemo((String)datas.get(7));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    quotaanalysisdetailVO.setErrorMsg("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(quotaanalysisdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    quotaanalysisdetailVO.setErrorMsg("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(quotaanalysisdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    quotaanalysisdetailVO.setErrorMsg("\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(quotaanalysisdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    quotaanalysisdetailVO.setErrorMsg("\u6295\u6807\u5de5\u7a0b\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(quotaanalysisdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    quotaanalysisdetailVO.setErrorMsg("\u5efa\u7b51\u9762\u79ef(m\u00b2)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(quotaanalysisdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    quotaanalysisdetailVO.setErrorMsg("\u6295\u6807\u6307\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(quotaanalysisdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    quotaanalysisdetailVO.setErrorMsg("(\u8ba1\u5212\u6210\u672c)\u9650\u989d\u8bbe\u8ba1\u6307\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(quotaanalysisdetailVO);
                    continue;
                }
                successList.add(quotaanalysisdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportQuotaanalysisFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportQuotaanalysisFromDatabase(@RequestBody QuotaanalysisVO quotaanalysisVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"quotaanalysis_id", (Object)quotaanalysisVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.quotaanalysisdetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("quotaanalysis-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportQuotaanalysisFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportQuotaanalysisFromPage(@RequestBody List<QuotaanalysisdetailVO> list, HttpServletResponse response) {
        HashMap<String, List<QuotaanalysisdetailVO>> beans = new HashMap<String, List<QuotaanalysisdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("quotaanalysis-export.xlsx", beans, response);
    }
}

