package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.EstimatesummaryEntity;
import com.ejianc.business.record.bean.RecordconsdrawbudgettotalEntity;
import com.ejianc.business.record.bean.RecordmaterialanalysisEntity;
import com.ejianc.business.record.service.IRecordmaterialanalysisService;
import com.ejianc.business.record.vo.RecordconsdrawbudgettotalVO;
import com.ejianc.business.record.vo.RecordmaterialanalysisVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.bean.MaterialanalysisEntity;
import com.ejianc.business.bedget.service.IMaterialanalysisService;
import com.ejianc.business.bedget.vo.MaterialanalysisVO;

/**
 * 施工图预算材料分析
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialanalysis")
public class MaterialanalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-materialanalysis";//此处需要根据实际修改

    @Autowired
    private IMaterialanalysisService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialanalysisVO> saveOrUpdate(@RequestBody MaterialanalysisVO saveorUpdateVO) {

    	MaterialanalysisEntity entity = BeanMapper.map(saveorUpdateVO, MaterialanalysisEntity.class);
        QueryWrapper<MaterialanalysisEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<MaterialanalysisEntity> pro = service.list(queryWrapper);
        if(pro.size() > 0){
            throw new BusinessException("该项目已经创建一个施工图预算材料分析，不允许重复创建!");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	MaterialanalysisVO vo = BeanMapper.map(entity, MaterialanalysisVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @Autowired
    private IRecordmaterialanalysisService recordmaterialanalysisService;
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialanalysisVO> queryDetail(Long id) {
    	MaterialanalysisEntity entity = service.selectById(id);
    	MaterialanalysisVO vo = BeanMapper.map(entity, MaterialanalysisVO.class);
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordmaterialanalysisEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_Id", vo.getId());
            List<RecordmaterialanalysisEntity> records = recordmaterialanalysisService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordmaterialanalysisVOS(BeanMapper.mapList(records, RecordmaterialanalysisVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialanalysisVO> vos) {
        service.removeByIds(vos.stream().map(MaterialanalysisVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<MaterialanalysisEntity> page = service.queryPage(param,false);
        IPage<MaterialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialanalysis-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialanalysisVO>> refMaterialanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialanalysisEntity> page = service.queryPage(param,false);
        IPage<MaterialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
