package com.ejianc.business.bedget.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import com.ejianc.business.bedget.bean.SubpackagematerialanalysisdetailEntity;
import com.ejianc.business.bedget.service.ISubpackagematerialanalysisdetailService;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;
import com.ejianc.business.bedget.vo.SubpackagematerialanalysisVO;
import com.ejianc.business.bedget.vo.SubpackagematerialanalysisdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分包施工图预算材料分析导入导出
 */
@Controller
@RequestMapping("subpackageMaterialanalysisExport")
public class ExcelSubpackageMaterialanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubpackagematerialanalysisdetailService subpackageMaterialanalysisdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadSubpackageMaterialanalysis")
    @ResponseBody
    public void downloadSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subpackagematerialanalysisdetail-import .xlsx", "物资需求总计划清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportSubpackageMaterialanalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SubpackagematerialanalysisdetailVO> successList = new ArrayList<>();
        List<SubpackagematerialanalysisdetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    SubpackagematerialanalysisdetailVO subpackagematerialanalysisdetailVO = new SubpackagematerialanalysisdetailVO();
                    subpackagematerialanalysisdetailVO.setId(IdWorker.getId());//id
                    subpackagematerialanalysisdetailVO.setSort(datas.get(0)); // 序号
                    subpackagematerialanalysisdetailVO.setMaterialsName(StringUtils.isNotBlank(datas.get(1))? datas.get(1):null); // 物资名称
                    subpackagematerialanalysisdetailVO.setSpec(StringUtils.isNotBlank(datas.get(2))? datas.get(2):null); // 规格型号
                    subpackagematerialanalysisdetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(3))? datas.get(3):null); // 计量单位
                    subpackagematerialanalysisdetailVO.setQuantitiesBase(StringUtils.isNotBlank(datas.get(4))? new BigDecimal(datas.get(4)):null); // 分包基础清单工程量
                    subpackagematerialanalysisdetailVO.setMaterialWasteRateBase(StringUtils.isNotBlank(datas.get(5))? new BigDecimal(datas.get(5)):null); // 合同约定基础用料损耗率
                    subpackagematerialanalysisdetailVO.setQuantitiesMain(StringUtils.isNotBlank(datas.get(6))? new BigDecimal(datas.get(6)):null); // 分包主体清单工程量
                    subpackagematerialanalysisdetailVO.setMaterialWasteRateMain(StringUtils.isNotBlank(datas.get(7))? new BigDecimal(datas.get(7)):null); // 合同约定主体用料损耗率
                    subpackagematerialanalysisdetailVO.setQuantitiesDecorate(StringUtils.isNotBlank(datas.get(8))? new BigDecimal(datas.get(8)):null); // 分包装修清单工程量
                    subpackagematerialanalysisdetailVO.setMaterialWasteRateDecorate(StringUtils.isNotBlank(datas.get(9))? new BigDecimal(datas.get(9)):null); // 合同约定装修用料损耗率
                    subpackagematerialanalysisdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(10))? datas.get(10):null); // 备注
                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }*/
                    successList.add(subpackagematerialanalysisdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackageMaterialanalysisFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromDatabase(@RequestBody SubpackagematerialanalysisVO subpackagematerialanalysisVO, HttpServletResponse response) {
        QueryWrapper<SubpackagematerialanalysisdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", subpackagematerialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<SubpackagematerialanalysisdetailEntity> list = subpackageMaterialanalysisdetailService.list(queryWrapper);
        List<SubpackagematerialanalysisdetailVO> subpackagematerialanalysisdetailVOList = BeanMapper.mapList(list, SubpackagematerialanalysisdetailVO.class);
        if (subpackagematerialanalysisdetailVOList != null && subpackagematerialanalysisdetailVOList.size() > 0) {
            for (int i = 0; i < subpackagematerialanalysisdetailVOList.size(); i++) {
                SubpackagematerialanalysisdetailVO subpackagematerialanalysisdetailVO = subpackagematerialanalysisdetailVOList.get(i);
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackagematerialanalysisdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackageMaterialanalysisFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromPage(@RequestBody List<SubpackagematerialanalysisdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SubpackagematerialanalysisdetailVO subpackagematerialanalysisdetailVO = list.get(i);
                subpackagematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackagematerialanalysisdetail-export.xlsx", beans, response);
    }
}
