package com.ejianc.business.bedget.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.service.IQuotadesigndetailService;
import com.ejianc.business.bedget.vo.QuotadesignVO;
import com.ejianc.business.bedget.vo.QuotadesigndetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 限额设计清单导入导出
 */
@Controller
@RequestMapping("quotadesignExport")
public class ExeclQuotadesignController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IQuotadesigndetailService quotadesigndetailService;


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadQuotadesign")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "quotadesigndetail-import.xlsx", "限额设计清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportQuotadesign", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<QuotadesigndetailVO> successList = new ArrayList<>();
        List<QuotadesigndetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    QuotadesigndetailVO quotadesigndetailVO = new QuotadesigndetailVO();
                    quotadesigndetailVO.setId(IdWorker.getId());//id
                    quotadesigndetailVO.setSort(datas.get(0)); // 序号
                    quotadesigndetailVO.setSonItemCode(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 子目编码
                    quotadesigndetailVO.setSonItemName(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 子目名称
                    quotadesigndetailVO.setSonItemDescribe(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 子目特征描述
                    quotadesigndetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 计量单位
                    quotadesigndetailVO.setEngineering(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 工程量
                    quotadesigndetailVO.setLabor(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); // 人工费(单价)
                    quotadesigndetailVO.setMaterial(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 材料费(单价)
                    quotadesigndetailVO.setMechanical(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 机械费(单价)
                    quotadesigndetailVO.setManagement(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 企业管理费(单价)
                    quotadesigndetailVO.setProfit(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 利润(单价)
                    quotadesigndetailVO.setUnitPrice(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 综合单价
                    quotadesigndetailVO.setShutLabor(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); // 人工费(综合)
                    quotadesigndetailVO.setShutMaterial(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null); // 材料费(综合)
                    quotadesigndetailVO.setShutMechanical(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null); // 机械费(综合)
                    quotadesigndetailVO.setShutManagement(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null); // 企业管理费
                    quotadesigndetailVO.setShutProfit(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : null); // 利润
                    quotadesigndetailVO.setShutPrice(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : null); // 合价
                    quotadesigndetailVO.setClubInsurance(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : null); // 社保
                    quotadesigndetailVO.setHousing(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) : null); // 住房
                    quotadesigndetailVO.setReserved1(StringUtils.isNotBlank(datas.get(20)) ?  new BigDecimal(datas.get(20)): null); //预留1
                    quotadesigndetailVO.setReserved2(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) : null); //预留2
                    quotadesigndetailVO.setReserved3(StringUtils.isNotBlank(datas.get(22)) ? new BigDecimal(datas.get(22)) : null); // 预留3
                    quotadesigndetailVO.setTax(StringUtils.isNotBlank(datas.get(23)) ? new BigDecimal(datas.get(23)) : null); // 税金
                    quotadesigndetailVO.setEstimation(StringUtils.isNotBlank(datas.get(24)) ? new BigDecimal(datas.get(24)) : null); // 暂估价
                    successList.add(quotadesigndetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @returnq
     */
    @RequestMapping(value = "/excelExportQuotadesignFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody QuotadesignVO quotadesignVO, HttpServletResponse response) {
        QueryWrapper<QuotadesigndetailEntity> queryWrapper;
        queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", quotadesignVO.getId());
        queryWrapper.eq("dr", 0);
        List<QuotadesigndetailEntity> list = quotadesigndetailService.list(queryWrapper);
        List<QuotadesigndetailVO> quotadesigndetailVOList = BeanMapper.mapList(list, QuotadesigndetailVO.class);
        if (quotadesigndetailVOList!= null && quotadesigndetailVOList.size() > 0) {
            for (int i = 0; i < quotadesigndetailVOList.size(); i++) {
                QuotadesigndetailVO quotadesigndetailVO = quotadesigndetailVOList.get(i);
               quotadesigndetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("quotadesigndetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportQuotadesignFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<QuotadesigndetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                QuotadesigndetailVO quotadesigndetailVO = list.get(i);
                quotadesigndetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("quotadesigndetail-export.xlsx", beans, response);
    }

}
