package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgettotalService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotalEntity;
import com.ejianc.business.change.mapper.ChangeconsdrawbudgettotalMapper;
import com.ejianc.business.change.service.IChangeconsdrawbudgettotalService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotalVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 施工预算图汇总表变更
 * 
 * @author generator
 * 
 */
@Service("changeconsdrawbudgettotalService")
public class ChangeconsdrawbudgettotalServiceImpl extends BaseServiceImpl<ChangeconsdrawbudgettotalMapper, ChangeconsdrawbudgettotalEntity> implements IChangeconsdrawbudgettotalService {

    @Autowired
    private IConsdrawbudgettotalService consdrawbudgettotalService;

    @Override
    public CommonResponse<ChangeconsdrawbudgettotalVO> saveChange(ChangeconsdrawbudgettotalVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeconsdrawbudgettotalEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeconsdrawbudgettotalEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeconsdrawbudgettotalEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeconsdrawbudgettotalEntity> queryWrapper = new QueryWrapper<ChangeconsdrawbudgettotalEntity>();
        queryWrapper.eq("change_mid", saveOrUpdateVO.getChangeMid());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeconsdrawbudgettotalEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //设计概算指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeconsdrawbudgettotalVO vo = BeanMapper.map(entity, ChangeconsdrawbudgettotalVO.class);
        vo.setChangeConsdrawtotaldetailEntities(saveOrUpdateVO.getChangeConsdrawtotaldetailEntities());
        vo.setRecordconsdrawbudgettotalVOS(saveOrUpdateVO.getRecordconsdrawbudgettotalVOS());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            ConsdrawbudgettotalEntity consdrawbudgettotalEntity = consdrawbudgettotalService.selectById(vo.getChangeMid());
            consdrawbudgettotalEntity.setChangeState("2");//状态改为变更中
            consdrawbudgettotalEntity.setChangeId(vo.getId());
            consdrawbudgettotalService.saveOrUpdate(consdrawbudgettotalEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
