package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.DesignestimateEntity;
import com.ejianc.business.bedget.bean.DesignestimatedetailEntity;
import com.ejianc.business.bedget.service.IDesignestimateService;

import com.ejianc.business.change.bean.ChangedesignestimateEntity;
import com.ejianc.business.change.bean.ChangedesignestimatedetailEntity;
import com.ejianc.business.change.service.IChangedesignestimateService;
import com.ejianc.business.record.bean.RecorddesignestimateEntity;
import com.ejianc.business.record.bean.RecorddesignestimatedetailEntity;
import com.ejianc.business.record.service.IRecorddesignestimateService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changedesignestimate") 
public class ChangedesignestimateBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	//业务类型
	private static final String Designestimate = "zjkj-designestimate";//限额设计指标分析
	private static final String Designestimate_CHANGE = "zjkj-designestimateChange";//限额设计指标分析变更
	private static final String Designestimate_RECORD = "zjkj-designestimateRecord";//限额设计指标分析变更记录

	//单据类型
	private static final String Designestimate_BILLTYPE_CODE = "BT202202000030";//限额设计指标分析
	private static final String Designestimate_CHANGE_BILLTYPE_CODE = "BT202202000031";//限额设计指标分析变更
	private static final String Designestimate_RECORD_BILLTYPE_CODE = "BT202202000032";//限额设计指标分析变更记录


	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangedesignestimateService changeDesignestimateService;
	@Autowired
	private IDesignestimateService designestimateService;
	@Autowired
	private IRecorddesignestimateService recorddesignestimateService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		logger.info("---------进来啦--------");
		//TODO
		//1、获取目前单据信息、变更信息
		ChangedesignestimateEntity changeEntity = changeDesignestimateService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getDesignestimateId());
		DesignestimateEntity designestimateEntity = designestimateService.selectById(changeEntity.getDesignestimateId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecorddesignestimateEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("designestimate_id", designestimateEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recorddesignestimateService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecorddesignestimateEntity recorddesignestimateEntity = BeanMapper.map(designestimateEntity, RecorddesignestimateEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recorddesignestimateEntity);
		recorddesignestimateEntity.setBillState(null);
		recorddesignestimateEntity.setDesignestimateId(designestimateEntity.getId());
		recorddesignestimateEntity.setDesignestimateCode(designestimateEntity.getBillCode()+"-"+(count+1));
		recorddesignestimateEntity.setId(recordId);
		recorddesignestimateEntity.setBillCode(designestimateEntity.getBillCode());
		recorddesignestimateEntity.setChangeReason(changeEntity.getChangeReason());
		recorddesignestimateEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<DesignestimatedetailEntity> quotaanalysisdetailEntities = designestimateEntity.getDesignestimatedetailEntities();
		if(quotaanalysisdetailEntities!=null&&quotaanalysisdetailEntities.size()>0){
			List<RecorddesignestimatedetailEntity> recorddesignestimatedetailEntities = new ArrayList<>();
			for(DesignestimatedetailEntity entity : quotaanalysisdetailEntities){
				RecorddesignestimatedetailEntity reEntity = BeanMapper.map(entity, RecorddesignestimatedetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setId(recordId);
				recorddesignestimatedetailEntities.add(reEntity);
				entity.setRowState("del");
			}
			recorddesignestimateEntity.setRecorddesignestimatedetailEntities(recorddesignestimatedetailEntities);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		sourceBillType = Designestimate_BILLTYPE_CODE;
		String targetBillType = "";
		targetBillType = Designestimate_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(designestimateEntity.getId().toString(), sourceBillType, Designestimate , recordId.toString(), targetBillType, Designestimate_RECORD);
		recorddesignestimateService.saveOrUpdate(recorddesignestimateEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + recorddesignestimateEntity.getCreateUserCode());
		//3、修改当前单据状态
		DesignestimateEntity designestimateEntity1 = BeanMapper.map(changeEntity, DesignestimateEntity.class);
		designestimateEntity1.setChangeState("3");//状态改为已变更
		designestimateEntity1.setChangeId(null);
		designestimateEntity1.setBillState(designestimateEntity.getBillState());
		designestimateEntity1.setId(designestimateEntity.getId());
		designestimateEntity1.setCreateTime(designestimateEntity.getCreateTime());
		designestimateEntity1.setCreateUserCode(designestimateEntity.getCreateUserCode());
		designestimateEntity1.setTenantId(designestimateEntity.getTenantId());
		designestimateEntity1.setVersion(designestimateEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangedesignestimatedetailEntity> changedesignestimatedetailEntities = changeEntity.getDesignestimatedetailEntities();
		if(changedesignestimatedetailEntities!=null&&changedesignestimatedetailEntities.size()>0){
			List<DesignestimatedetailEntity> newDesignestimatedetailEntity = BeanMapper.mapList(changedesignestimatedetailEntities, DesignestimatedetailEntity.class);
			newDesignestimatedetailEntity.addAll(quotaanalysisdetailEntities);
			designestimateEntity1.setDesignestimatedetailEntities(newDesignestimatedetailEntity);
		}
		logger.info("---------保存--------");
		designestimateService.saveOrUpdate(designestimateEntity1, false);

		sourceBillType = Designestimate_CHANGE_BILLTYPE_CODE;
		targetBillType = Designestimate_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Designestimate_CHANGE, designestimateEntity.getId().toString(), targetBillType, Designestimate);
		recorddesignestimateService.saveOrUpdate(recorddesignestimateEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
