package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.EstimatesummaryEntity;
import com.ejianc.business.bedget.bean.EstimatesummarydetailEntity;
import com.ejianc.business.bedget.service.IEstimatesummaryService;
import com.ejianc.business.change.bean.ChangeestimatesummaryEntity;
import com.ejianc.business.change.bean.ChangeestimatesummarydetailEntity;
import com.ejianc.business.change.service.IChangeestimatesummaryService;
import com.ejianc.business.record.bean.RecordestimatesummaryEntity;
import com.ejianc.business.record.bean.RecordestsumdetailEntity;
import com.ejianc.business.record.service.IRecordestimatesummaryService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeestimatesummary") 
public class ChangeestimatesummaryBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	//业务类型
	private static final String Estimatesummary = "zjkj-designestimate";//限额设计指标分析
	private static final String Estimatesummary_CHANGE = "zjkj-designestimateChange";//限额设计指标分析变更
	private static final String Estimatesummary_RECORD = "zjkj-designestimateRecord";//限额设计指标分析变更记录

	//单据类型
	private static final String Estimatesummary_BILLTYPE_CODE = "BT202202000030";//限额设计指标分析
	private static final String Estimatesummary_CHANGE_BILLTYPE_CODE = "BT202202000031";//限额设计指标分析变更
	private static final String Estimatesummary_RECORD_BILLTYPE_CODE = "BT202202000032";//限额设计指标分析变更记录
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}



	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	@Autowired
	private IChangeestimatesummaryService changeEstimatesummaryService;
	@Autowired
	private IEstimatesummaryService estimatesummaryService;
	@Autowired
	private IRecordestimatesummaryService recordestimatesummaryService;
	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		logger.info("---------进来啦--------");
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeestimatesummaryEntity changeEntity = changeEstimatesummaryService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getBudgetestimatesummarId());
		EstimatesummaryEntity estimatesummaryEntity = estimatesummaryService.selectById(changeEntity.getBudgetestimatesummarId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordestimatesummaryEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("budgetestimatesummary_id", estimatesummaryEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordestimatesummaryService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordestimatesummaryEntity recordestimatesummaryEntity = BeanMapper.map(estimatesummaryEntity, RecordestimatesummaryEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordestimatesummaryEntity);
		recordestimatesummaryEntity.setBillState(null);
		recordestimatesummaryEntity.setBudgetestimatesummaryId(estimatesummaryEntity.getId());
		recordestimatesummaryEntity.setBudgetestimatesummaryCode(estimatesummaryEntity.getBillCode()+"-"+(count+1));
		recordestimatesummaryEntity.setId(recordId);
		recordestimatesummaryEntity.setBillCode(estimatesummaryEntity.getBillCode());
		recordestimatesummaryEntity.setChangeReason(changeEntity.getChangeReason());
		recordestimatesummaryEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<EstimatesummarydetailEntity> estimatesummarydetailEntities = estimatesummaryEntity.getEstimatesummarydetailEntities();
		if(estimatesummarydetailEntities!=null&&estimatesummarydetailEntities.size()>0){
			List<RecordestsumdetailEntity> recorddesignestimatedetailEntities = new ArrayList<>();
			for(EstimatesummarydetailEntity entity : estimatesummarydetailEntities){
				RecordestsumdetailEntity reEntity = BeanMapper.map(entity, RecordestsumdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setId(recordId);
				recorddesignestimatedetailEntities.add(reEntity);
				entity.setRowState("del");
			}
			recordestimatesummaryEntity.setRecordestsumdetailEntities(recorddesignestimatedetailEntities);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		sourceBillType = Estimatesummary_BILLTYPE_CODE;
		String targetBillType = "";
		targetBillType = Estimatesummary_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(estimatesummaryEntity.getId().toString(), sourceBillType, Estimatesummary , recordId.toString(), targetBillType, Estimatesummary_RECORD);
		recordestimatesummaryService.saveOrUpdate(recordestimatesummaryEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + recordestimatesummaryEntity.getCreateUserCode());
		//3、修改当前单据状态
		EstimatesummaryEntity designestimateEntity1 = BeanMapper.map(changeEntity, EstimatesummaryEntity.class);
		designestimateEntity1.setChangeState("3");//状态改为已变更
		designestimateEntity1.setChangeId(null);
		designestimateEntity1.setBillState(estimatesummaryEntity.getBillState());
		designestimateEntity1.setId(estimatesummaryEntity.getId());
		designestimateEntity1.setCreateTime(estimatesummaryEntity.getCreateTime());
		designestimateEntity1.setCreateUserCode(estimatesummaryEntity.getCreateUserCode());
		designestimateEntity1.setTenantId(estimatesummaryEntity.getTenantId());
		designestimateEntity1.setVersion(estimatesummaryEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangeestimatesummarydetailEntity> changeestimatesummarydetailEntities = changeEntity.getChangeestimatesummarydetailEntities();
		if(changeestimatesummarydetailEntities!=null&&changeestimatesummarydetailEntities.size()>0){
			List<EstimatesummarydetailEntity> newEstimatesummarydetailEntity = BeanMapper.mapList(changeestimatesummarydetailEntities, EstimatesummarydetailEntity.class);
			newEstimatesummarydetailEntity.addAll(estimatesummarydetailEntities);
			designestimateEntity1.setEstimatesummarydetailEntities(newEstimatesummarydetailEntity);
		}
		logger.info("---------保存--------");
		estimatesummaryService.saveOrUpdate(designestimateEntity1, false);

		sourceBillType = Estimatesummary_CHANGE_BILLTYPE_CODE;
		targetBillType = Estimatesummary_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Estimatesummary_CHANGE, estimatesummaryEntity.getId().toString(), targetBillType, Estimatesummary);
		recordestimatesummaryService.saveOrUpdate(recordestimatesummaryEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
