package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.EstimatesummaryEntity;
import com.ejianc.business.bedget.service.IEstimatesummaryService;
import com.ejianc.business.change.bean.ChangeestimatesummaryEntity;
import com.ejianc.business.change.mapper.ChangeestimatesummaryMapper;
import com.ejianc.business.change.service.IChangeestimatesummaryService;
import com.ejianc.business.change.vo.ChangeestimatesummaryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 设计概算汇总表变更
 * 
 * @author generator
 * 
 */
@Service("changeestimatesummaryService")
public class ChangeestimatesummaryServiceImpl extends BaseServiceImpl<ChangeestimatesummaryMapper, ChangeestimatesummaryEntity> implements IChangeestimatesummaryService {
    @Autowired
    private IEstimatesummaryService estimatesummaryService;


    @Override
    public CommonResponse<ChangeestimatesummaryVO> saveChange(ChangeestimatesummaryVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeestimatesummaryEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeestimatesummaryEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeestimatesummaryEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeestimatesummaryEntity> queryWrapper = new QueryWrapper<ChangeestimatesummaryEntity>();
        queryWrapper.eq("budgetestimatesummar_id", saveOrUpdateVO.getBudgetestimatesummarId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeestimatesummaryEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //设计概算指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeestimatesummaryVO vo = BeanMapper.map(entity, ChangeestimatesummaryVO.class);
        vo.setChangeestimatesummarydetailEntities(saveOrUpdateVO.getChangeestimatesummarydetailEntities());
        vo.setRecorddesignestimatedetailVOList(saveOrUpdateVO.getRecorddesignestimatedetailVOList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            EstimatesummaryEntity estimatesummaryEntity = estimatesummaryService.selectById(vo.getBudgetestimatesummarId());
            estimatesummaryEntity.setChangeState("2");//状态改为变更中
            estimatesummaryEntity.setChangeId(vo.getId());
            estimatesummaryService.saveOrUpdate(estimatesummaryEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
