package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.change.bean.ChangequotadesignEntity;
import com.ejianc.business.change.mapper.ChangequotadesignMapper;
import com.ejianc.business.change.service.IChangequotadesignService;
import com.ejianc.business.change.vo.ChangequotadesignVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 限额设计表变更
 * 
 * @author generator
 * 
 */
@Service("changequotadesignService")
public class ChangequotadesignServiceImpl extends BaseServiceImpl<ChangequotadesignMapper, ChangequotadesignEntity> implements IChangequotadesignService {

    @Autowired
    private IQuotadesignService quotadesignService;
    @Override
    public CommonResponse<ChangequotadesignVO> saveChange(ChangequotadesignVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangequotadesignEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangequotadesignEntity entity = BeanMapper.map(saveOrUpdateVO, ChangequotadesignEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangequotadesignEntity> queryWrapper = new QueryWrapper<ChangequotadesignEntity>();
        queryWrapper.eq("quotadesign_id", saveOrUpdateVO.getQuotadesignId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangequotadesignEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangequotadesignVO vo = BeanMapper.map(entity, ChangequotadesignVO.class);
        vo.setQuotadesigndetailEntities(saveOrUpdateVO.getQuotadesigndetailEntities());
        vo.setRecordquotadesignList(saveOrUpdateVO.getRecordquotadesignList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            QuotadesignEntity quotadesignEntity = quotadesignService.selectById(vo.getQuotadesignId());
            quotadesignEntity.setChangeState("2");//状态改为变更中
            quotadesignEntity.setChangeId(vo.getId());
            quotadesignService.saveOrUpdate(quotadesignEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
