package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotasummaryEntity;
import com.ejianc.business.bedget.service.IQuotasummaryService;
import com.ejianc.business.change.bean.ChangequotasummaryEntity;
import com.ejianc.business.change.mapper.ChangequotasummaryMapper;
import com.ejianc.business.change.service.IChangequotasummaryService;
import com.ejianc.business.change.vo.ChangequotasummaryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 限额设计汇总变更
 * 
 * @author generator
 * 
 */
@Service("changequotasummaryService")
public class ChangequotasummaryServiceImpl extends BaseServiceImpl<ChangequotasummaryMapper, ChangequotasummaryEntity> implements IChangequotasummaryService {

    @Autowired
    private IQuotasummaryService quotasummaryService;
    @Override
    public CommonResponse<ChangequotasummaryVO> saveChange(ChangequotasummaryVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangequotasummaryEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangequotasummaryEntity entity = BeanMapper.map(saveOrUpdateVO, ChangequotasummaryEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangequotasummaryEntity> queryWrapper = new QueryWrapper<ChangequotasummaryEntity>();
        queryWrapper.eq("quotasummary_id", saveOrUpdateVO.getQuotasummaryId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangequotasummaryEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangequotasummaryVO vo = BeanMapper.map(entity, ChangequotasummaryVO.class);
        vo.setQuotasummarydetailEntities(saveOrUpdateVO.getQuotasummarydetailEntities());
        vo.setRecordquotasummaryList(saveOrUpdateVO.getRecordquotasummaryList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            QuotasummaryEntity quotasummaryEntity = quotasummaryService.selectById(vo.getQuotasummaryId());
            quotasummaryEntity.setChangeState("2");//状态改为变更中
            quotasummaryEntity.setChangeId(vo.getId());
            quotasummaryService.saveOrUpdate(quotasummaryEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
