package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.vo.ConsdrawbudgetdetailVO;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;
import com.ejianc.business.record.bean.RecordQuotaanalysisEntity;
import com.ejianc.business.record.bean.RecordconsdrawbudgetEntity;
import com.ejianc.business.record.service.IRecordQuotaanalysisService;
import com.ejianc.business.record.service.IRecordconsdrawbudgetService;
import com.ejianc.business.record.vo.RecordQuotaanalysisVO;
import com.ejianc.business.record.vo.RecordconsdrawbudgetVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.vo.ConsdrawbudgetVO;

/**
 * 施工图预算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("consdrawbudget")
public class ConsdrawbudgetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-consdrawbudget";//此处需要根据实际修改

    @Autowired
    private IConsdrawbudgetService service;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;
    @Autowired
    private IRecordconsdrawbudgetService recordconsdrawbudgetService;
    @Autowired
    private SubpackageController subpackageController;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConsdrawbudgetVO> saveOrUpdate(@RequestBody ConsdrawbudgetVO saveorUpdateVO) {
    	ConsdrawbudgetEntity entity = BeanMapper.map(saveorUpdateVO, ConsdrawbudgetEntity.class);
        QueryWrapper<ConsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<ConsdrawbudgetEntity> pro = service.list(queryWrapper);
        if(pro.size() > 0){
            throw new BusinessException("该项目已经创建一个施工图预算，不允许重复创建!");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ConsdrawbudgetVO vo = BeanMapper.map(entity, ConsdrawbudgetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConsdrawbudgetVO> queryDetail(Long id) {
    	ConsdrawbudgetEntity entity = service.selectById(id);
    	ConsdrawbudgetVO vo = BeanMapper.map(entity, ConsdrawbudgetVO.class);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordconsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("consdrawbudget_id", vo.getId());
            List<RecordconsdrawbudgetEntity> records = recordconsdrawbudgetService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordconsdrawbudgetVOS(BeanMapper.mapList(records, RecordconsdrawbudgetVO.class));
            }
        }

        //构建树形结构
        List<ConsdrawbudgetdetailVO> consdrawbudgetdetailEntities = vo.getConsdrawbudgetdetailEntities();

        List<ConsdrawbudgetdetailVO> resConsdrawbudgetdetailVO = createTreeData(consdrawbudgetdetailEntities);
        vo.setConsdrawbudgetdetailEntities(resConsdrawbudgetdetailVO);

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConsdrawbudgetVO> vos) {
        service.removeByIds(vos.stream().map(ConsdrawbudgetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConsdrawbudgetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ConsdrawbudgetEntity> page = service.queryPage(param,false);
        IPage<ConsdrawbudgetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConsdrawbudgetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConsdrawbudgetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Consdrawbudget-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refConsdrawbudgetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConsdrawbudgetVO>> refConsdrawbudgetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ConsdrawbudgetEntity> page = service.queryPage(param,false);
        IPage<ConsdrawbudgetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConsdrawbudgetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refConsdrawbudgetDataDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubpackagedetailVO>> refConsdrawbudgetDataDetail(Long projectId) {
        List<SubpackagedetailVO> recordsVo = new ArrayList<>();
        QueryWrapper<ConsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        ConsdrawbudgetEntity entity = service.getOne(queryWrapper);
        if(entity == null){
            throw new BusinessException("该项目没有施工图预算,请选择别的项目");
        }else{
            QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("dr", 0);
            queryWrapper1.eq("mid", entity.getId());
            List<ConsdrawbudgetdetailEntity> records = consdrawbudgetdetailService.list(queryWrapper1);
            for(ConsdrawbudgetdetailEntity entity1 : records){
                SubpackagedetailVO subpackagedetailVO = new SubpackagedetailVO();
                subpackagedetailVO.setSort(entity1.getSort());
                subpackagedetailVO.setSection(entity1.getSection());
                subpackagedetailVO.setSubtitleCode(entity1.getSubitemCode());
                subpackagedetailVO.setSubtitleName(entity1.getSubitemName());
                subpackagedetailVO.setSubtitleFeature(entity1.getCharacterDescrip());
                subpackagedetailVO.setMeasuringUnit(entity1.getEstimateUnit());
                subpackagedetailVO.setTid(entity1.getTid());
                subpackagedetailVO.setTpid(entity1.getTpid());
                recordsVo.add(subpackagedetailVO);
            }
            if(recordsVo.size() > 1){
                //构建树
                recordsVo = subpackageController.createTreeData(recordsVo);
            }
        }
        return CommonResponse.success("查询参照数据成功！",recordsVo);
    }

    public static List<ConsdrawbudgetdetailVO> createTreeData(List<ConsdrawbudgetdetailVO> list) {
        List<ConsdrawbudgetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ConsdrawbudgetdetailVO> listMap = new HashMap<>();
        for(ConsdrawbudgetdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ConsdrawbudgetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ConsdrawbudgetdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ConsdrawbudgetdetailVO> child = (List<ConsdrawbudgetdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ConsdrawbudgetdetailVO> children = new ArrayList<ConsdrawbudgetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
