package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailInnateEntity;
import com.ejianc.business.bedget.service.IQuotaanalysisdetailInnateService;
import com.ejianc.business.record.bean.RecordQuotaanalysisEntity;
import com.ejianc.business.record.service.IRecordQuotaanalysisService;
import com.ejianc.business.record.vo.RecordQuotaanalysisVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.bean.QuotaanalysisEntity;
import com.ejianc.business.bedget.service.IQuotaanalysisService;
import com.ejianc.business.bedget.vo.QuotaanalysisVO;

/**
 * 限额设计指标分析
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("quotaanalysis")
public class QuotaanalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IQuotaanalysisdetailInnateService quotaanalysisdetailInnateService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IQuotaanalysisService service;
    @Autowired
    private IRecordQuotaanalysisService recordQuotaanalysisService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotaanalysisVO> saveOrUpdate(@RequestBody QuotaanalysisVO saveorUpdateVO) {
    	QuotaanalysisEntity entity = BeanMapper.map(saveorUpdateVO, QuotaanalysisEntity.class);

        QueryWrapper<QuotaanalysisEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<QuotaanalysisEntity> pro = service.list(queryWrapper);

    	if(entity.getId() == null || entity.getId() == 0){
            if(pro.size() > 0){
                throw new BusinessException("该项目已经创建一个限额设计指标分析，不允许重复创建!");
            }

            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            if(pro.size() > 0){
                for (int i = 0; i < pro.size(); i++) {
                    if(!entity.getId().equals(pro.get(i).getId())){
                        throw new BusinessException("该项目已经创建一个限额设计指标分析，不允许重复创建!!");
                    }
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	QuotaanalysisVO vo = BeanMapper.map(entity, QuotaanalysisVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuotaanalysisVO> queryDetail(Long id) {
    	QuotaanalysisEntity entity = service.selectById(id);
    	QuotaanalysisVO vo = BeanMapper.map(entity, QuotaanalysisVO.class);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordQuotaanalysisEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("quotaanalysis_id", vo.getId());
            List<RecordQuotaanalysisEntity> records = recordQuotaanalysisService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordQuotaanalysisList(BeanMapper.mapList(records, RecordQuotaanalysisVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryInnateColumns 查询固定列
     * @param
     */
    @RequestMapping(value = "/queryInnateColumns", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<QuotaanalysisdetailInnateEntity>> queryInnateColumns() {
        //查询固定列
        QueryWrapper<QuotaanalysisdetailInnateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", "0");
        queryWrapper.orderByAsc("id");
        List<QuotaanalysisdetailInnateEntity> pro = quotaanalysisdetailInnateService.list(queryWrapper);
        return CommonResponse.success("查询固定列数据成功！",pro);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotaanalysisVO> vos) {
        service.removeByIds(vos.stream().map(QuotaanalysisVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuotaanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<QuotaanalysisEntity> page = service.queryPage(param,false);
        IPage<QuotaanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotaanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<QuotaanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Quotaanalysis-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refQuotaanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuotaanalysisVO>> refQuotaanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<QuotaanalysisEntity> page = service.queryPage(param,false);
        IPage<QuotaanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotaanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
