package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.bedget.service.IQuotadesigndetailService;
import com.ejianc.business.bedget.vo.QuotasummarydetailVO;
import com.ejianc.business.record.bean.RecordQuotaanalysisEntity;
import com.ejianc.business.record.bean.RecordquotasummaryEntity;
import com.ejianc.business.record.service.IRecordquotasummaryService;
import com.ejianc.business.record.vo.RecordQuotaanalysisVO;
import com.ejianc.business.record.vo.RecordquotasummaryVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.bean.QuotasummaryEntity;
import com.ejianc.business.bedget.service.IQuotasummaryService;
import com.ejianc.business.bedget.vo.QuotasummaryVO;

/**
 * 限额设计汇总
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("quotasummary")
public class QuotasummaryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanage-quotasummary";//此处需要根据实际修改

    @Autowired
    private IQuotasummaryService service;
    @Autowired
    private IQuotadesignService quotadesignService;
    @Autowired
    private IQuotadesigndetailService quotadesigndetailService;
    @Autowired
    private IRecordquotasummaryService recordquotasummaryService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotasummaryVO> saveOrUpdate(@RequestBody QuotasummaryVO saveorUpdateVO) {
    	QuotasummaryEntity entity = BeanMapper.map(saveorUpdateVO, QuotasummaryEntity.class);

    	if(entity.getId() == null || entity.getId() == 0){
            QueryWrapper<QuotasummaryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id", entity.getProjectId());
            queryWrapper.eq("dr", "0");
            List<QuotasummaryEntity> pro = service.list(queryWrapper);
            if(pro.size() > 0){
                throw new BusinessException("该项目已经创建一个限额设计汇总，不允许重复创建!");
            }
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	QuotasummaryVO vo = BeanMapper.map(entity, QuotasummaryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuotasummaryVO> queryDetail(Long id) {
    	QuotasummaryEntity entity = service.selectById(id);
    	QuotasummaryVO vo = BeanMapper.map(entity, QuotasummaryVO.class);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordquotasummaryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("quotasummary_id", vo.getId());
            List<RecordquotasummaryEntity> records = recordquotasummaryService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordquotasummaryList(BeanMapper.mapList(records, RecordquotasummaryVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotasummaryVO> vos) {
        service.removeByIds(vos.stream().map(QuotasummaryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuotasummaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<QuotasummaryEntity> page = service.queryPage(param,false);
        IPage<QuotasummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotasummaryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<QuotasummaryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Quotasummary-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refQuotasummaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuotasummaryVO>> refQuotasummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<QuotasummaryEntity> page = service.queryPage(param,false);
        IPage<QuotasummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotasummaryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryDetail 查询详情
     * @param projectId
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<QuotasummarydetailVO>> queryDetailList(Long projectId) {
        List<QuotasummarydetailVO> vo = new ArrayList<>();
        //根据项目id查询限额设计表数据
        QueryWrapper<QuotadesignEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 1, 3);
        QuotadesignEntity entity = quotadesignService.getOne(queryWrapper);
        if(entity == null){
            throw  new BusinessException("您选择的项目没有限额设计,请选择别的项目");
        }else{
            //根据主表id和tpid为空 查询子表第一层数据
            QueryWrapper<QuotadesigndetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("mid",entity.getId());
            queryWrapper1.eq("dr", 0);
            queryWrapper1.eq("tpid", "");
            List<QuotadesigndetailEntity> list = quotadesigndetailService.list(queryWrapper1);
            if(list == null){
                throw  new BusinessException("您选择的项目没有限额设计清单,请选择别的项目");
            }else{
                for(QuotadesigndetailEntity quotadesigndetailEntity : list){
                    //循环将第一层数据的值赋值给清单
                    QuotasummarydetailVO quotasummarydetailVO = new QuotasummarydetailVO();
                    quotasummarydetailVO.setId(IdWorker.getId());
                    quotasummarydetailVO.setSort(String.valueOf(quotadesigndetailEntity.getSonItemCode()));
                    quotasummarydetailVO.setUnitProjectName(quotadesigndetailEntity.getSonItemName());
                    quotasummarydetailVO.setLaborCost(quotadesigndetailEntity.getShutLabor());
                    quotasummarydetailVO.setMaterialCost(quotadesigndetailEntity.getShutMaterial());
                    quotasummarydetailVO.setMechanicalCost(quotadesigndetailEntity.getShutMechanical());
                    quotasummarydetailVO.setManagementCost(quotadesigndetailEntity.getShutManagement());
                    quotasummarydetailVO.setProfit(quotadesigndetailEntity.getShutProfit());
                    quotasummarydetailVO.setPartialItemTotal(quotadesigndetailEntity.getShutPrice());
                    quotasummarydetailVO.setFees(quotadesigndetailEntity.getClubInsurance().add(quotadesigndetailEntity.getHousing())
                            .add(quotadesigndetailEntity.getReserved1()).add(quotadesigndetailEntity.getReserved2())
                            .add(quotadesigndetailEntity.getReserved3()));
                    quotasummarydetailVO.setTax(quotadesigndetailEntity.getTax());
                    quotasummarydetailVO.setTid(quotadesigndetailEntity.getTid());
                    quotasummarydetailVO.setTpid(quotadesigndetailEntity.getTpid());
                    quotasummarydetailVO.setRowState("add");
                    //根据主表id和第一层数据的父id查询第二层数据
                    QueryWrapper<QuotadesigndetailEntity> queryWrapper2 = new QueryWrapper<>();
                    queryWrapper2.eq("mid",entity.getId());
                    queryWrapper2.eq("dr", 0);
                    queryWrapper2.eq("tpid", quotadesigndetailEntity.getTid());
                    List<QuotadesigndetailEntity> list1 = quotadesigndetailService.list(queryWrapper2);
                    if(list1 != null){
                        for(QuotadesigndetailEntity  quotadesigndetailEntity1: list1){
                            List<QuotasummarydetailVO> quotasummarydetailVOS = new ArrayList<>();
                            QuotasummarydetailVO quotasummarydetailVO1 = new QuotasummarydetailVO();
                            quotasummarydetailVO1.setId(IdWorker.getId());
                            quotasummarydetailVO1.setSort(quotadesigndetailEntity1.getSonItemCode());
                            quotasummarydetailVO1.setUnitProjectName(quotadesigndetailEntity1.getSonItemName());
                            quotasummarydetailVO1.setLaborCost(quotadesigndetailEntity1.getShutLabor());
                            quotasummarydetailVO1.setMaterialCost(quotadesigndetailEntity1.getShutMaterial());
                            quotasummarydetailVO1.setMechanicalCost(quotadesigndetailEntity1.getShutMechanical());
                            quotasummarydetailVO1.setManagementCost(quotadesigndetailEntity1.getShutManagement());
                            quotasummarydetailVO1.setProfit(quotadesigndetailEntity1.getShutProfit());
                            quotasummarydetailVO1.setPartialItemTotal(quotadesigndetailEntity1.getShutPrice());
                            quotasummarydetailVO1.setFees(quotadesigndetailEntity1.getClubInsurance().add(quotadesigndetailEntity1.getHousing())
                                    .add(quotadesigndetailEntity1.getReserved1()).add(quotadesigndetailEntity1.getReserved2())
                                    .add(quotadesigndetailEntity1.getReserved3()));
                            quotasummarydetailVO1.setTax(quotadesigndetailEntity1.getTax());
                            quotasummarydetailVO1.setTid(quotadesigndetailEntity1.getTid());
                            quotasummarydetailVO1.setTpid(quotadesigndetailEntity1.getTpid());
                            quotasummarydetailVO1.setRowState("add");
                            quotasummarydetailVOS.add(quotasummarydetailVO1);
                            //将第二层数据添加到第一层数据下
                            quotasummarydetailVO.setChildren(quotasummarydetailVOS);
                        }
                    }
                    vo.add(quotasummarydetailVO);
                }
            }

        }
        return CommonResponse.success(vo);

    }
}
