package com.ejianc.business.bedget.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.service.IQuotadesigndetailService;
import com.ejianc.business.bedget.vo.QuotadesignVO;
import com.ejianc.business.bedget.vo.QuotadesigndetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 限额设计清单导入导出
 */
@Controller
@RequestMapping("quotadesignExport")
public class ExeclQuotadesignController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IQuotadesigndetailService quotadesigndetailService;


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadQuotadesign")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "quotadesigndetail-import.xlsx", "限额设计清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportQuotadesign", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<QuotadesigndetailVO> successList = new ArrayList<>();
        List<QuotadesigndetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);

                    String sonItemCode = datas.get(1);
                    QuotadesigndetailVO quotadesigndetailVO = new QuotadesigndetailVO();
                    quotadesigndetailVO.setId(IdWorker.getId());//id
                    quotadesigndetailVO.setSort(datas.get(0)); // 序号
                    quotadesigndetailVO.setSonItemCode(StringUtils.isNotBlank(sonItemCode) ? sonItemCode : null); // 子目编码
                    quotadesigndetailVO.setSonItemName(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 子目名称
                    quotadesigndetailVO.setSonItemDescribe(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 子目特征描述
                    quotadesigndetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 计量单位
                    quotadesigndetailVO.setEngineering(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 工程量
                    quotadesigndetailVO.setLabor(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); // 人工费(单价)
                    quotadesigndetailVO.setMaterial(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 材料费(单价)
                    quotadesigndetailVO.setMechanical(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 机械费(单价)
                    quotadesigndetailVO.setManagement(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 企业管理费(单价)
                    quotadesigndetailVO.setProfit(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 利润(单价)
                    quotadesigndetailVO.setUnitPrice(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 综合单价
                    quotadesigndetailVO.setShutLabor(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); // 人工费(综合)
                    quotadesigndetailVO.setShutMaterial(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null); // 材料费(综合)
                    quotadesigndetailVO.setShutMechanical(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null); // 机械费(综合)
                    quotadesigndetailVO.setShutManagement(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null); // 企业管理费
                    quotadesigndetailVO.setShutProfit(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : null); // 利润
                    quotadesigndetailVO.setShutPrice(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : null); // 合价
                    quotadesigndetailVO.setClubInsurance(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : null); // 社保
                    quotadesigndetailVO.setHousing(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) : null); // 住房
                    quotadesigndetailVO.setReserved1(StringUtils.isNotBlank(datas.get(20)) ? new BigDecimal(datas.get(20)) : null); //预留1
                    quotadesigndetailVO.setReserved2(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) : null); //预留2
                    quotadesigndetailVO.setReserved3(StringUtils.isNotBlank(datas.get(22)) ? new BigDecimal(datas.get(22)) : null); // 预留3
                    quotadesigndetailVO.setTax(StringUtils.isNotBlank(datas.get(23)) ? new BigDecimal(datas.get(23)) : null); // 税金
                    quotadesigndetailVO.setEstimation(StringUtils.isNotBlank(datas.get(24)) ? new BigDecimal(datas.get(24)) : null); // 暂估价

                    //1、校验编码是否符合规则--2、4、6、9、9以上
                    if (sonItemCode == null || !(sonItemCode.length() == 2 || sonItemCode.length() == 4 || sonItemCode.length() == 6 || sonItemCode.length() >= 9)) {
                        quotadesigndetailVO.setErrorMsg("子目编码必须符合：2位、4位、6位、9位或9位以上中任意一规则");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }
                    successList.add(quotadesigndetailVO);
                }
            }
        }

        //设置tid和tpid
        List<QuotadesigndetailVO> resList = setTidAndTpid(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        QuotadesignVO resVo = new QuotadesignVO();
        json.put("total", getTotalAmount(resList, resVo));

        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     *
     * @param originalList
     * @return
     */
    private List<QuotadesigndetailVO> setTidAndTpid(List<QuotadesigndetailVO> originalList) {
        List<QuotadesigndetailVO> treeList = new ArrayList<>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); i++) {
                QuotadesigndetailVO quotadesigndetailVO = originalList.get(i);
                String sonItemCode = quotadesigndetailVO.getSonItemCode();

                if (sonItemCode.length() == 2) {
                    quotadesigndetailVO.setTid(currentTime + "_" + sonItemCode);
                    quotadesigndetailVO.setTpid("");
                    treeList.add(quotadesigndetailVO);
                } else if (sonItemCode.length() < 9) {
                    quotadesigndetailVO.setTid(currentTime + "_" + sonItemCode);
                    quotadesigndetailVO.setTpid(currentTime + "_" + sonItemCode.substring(0, sonItemCode.length() - 2));
                    treeList.add(quotadesigndetailVO);
                } else {
                    quotadesigndetailVO.setTid(currentTime + "_" + sonItemCode);
                    quotadesigndetailVO.setTpid(currentTime + "_" + sonItemCode.substring(0, 6));//前6位
                    treeList.add(quotadesigndetailVO);
                }
            }
        }
        return createTreeData(treeList);
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<QuotadesigndetailVO> createTreeData(List<QuotadesigndetailVO> list) {
        List<QuotadesigndetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, QuotadesigndetailVO> listMap = new HashMap<>();
        for (QuotadesigndetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            QuotadesigndetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            QuotadesigndetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<QuotadesigndetailVO> child = (List<QuotadesigndetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<QuotadesigndetailVO> children = new ArrayList<QuotadesigndetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private QuotadesignVO getTotalAmount(List<QuotadesigndetailVO> vos, QuotadesignVO resVo) {
        BigDecimal costTotal = new BigDecimal(0);
        BigDecimal laborTotal = new BigDecimal(0);
        BigDecimal materialTotal = new BigDecimal(0);
        BigDecimal mechanicalTotal = new BigDecimal(0);
        BigDecimal profitsTotal = new BigDecimal(0);
        BigDecimal managementTotal = new BigDecimal(0);
        BigDecimal feesTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);

        for (QuotadesigndetailVO vo : vos) {
            if (vo.getShutPrice() != null) {
                costTotal = costTotal.add(vo.getShutPrice());
            }
            if (vo.getShutLabor() != null) {
                laborTotal = laborTotal.add(vo.getShutLabor());
            }
            if (vo.getShutMaterial() != null) {
                materialTotal = materialTotal.add(vo.getShutMaterial());
            }
            if (vo.getShutMechanical() != null) {
                mechanicalTotal = mechanicalTotal.add(vo.getShutMechanical());
            }
            if (vo.getShutProfit() != null) {
                profitsTotal = profitsTotal.add(vo.getShutProfit());
            }
            if (vo.getShutManagement() != null) {
                managementTotal = managementTotal.add(vo.getShutManagement());
            }
            if (vo.getTax() != null) {
                taxTotal = taxTotal.add(vo.getTax());
            }

            //规费合计
            if (vo.getClubInsurance() != null) {
                feesTotal = feesTotal.add(vo.getClubInsurance());
            }
            if (vo.getHousing() != null) {
                feesTotal = feesTotal.add(vo.getHousing());
            }
            if (vo.getReserved1() != null) {
                feesTotal = feesTotal.add(vo.getReserved1());
            }
            if (vo.getReserved2() != null) {
                feesTotal = feesTotal.add(vo.getReserved2());
            }
            if (vo.getReserved3() != null) {
                feesTotal = feesTotal.add(vo.getReserved3());
            }
        }

        resVo.setCostTotal(costTotal);
        resVo.setLaborTotal(laborTotal);
        resVo.setMaterialTotal(materialTotal);
        resVo.setMechanicalTotal(mechanicalTotal);
        resVo.setProfitsTotal(profitsTotal);
        resVo.setManagementTotal(managementTotal);
        resVo.setFeesTotal(feesTotal);
        resVo.setTaxTotal(taxTotal);
        return resVo;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @returnq
     */
    @RequestMapping(value = "/excelExportQuotadesignFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody QuotadesignVO quotadesignVO, HttpServletResponse response) {
        QueryWrapper<QuotadesigndetailEntity> queryWrapper;
        queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", quotadesignVO.getId());
        queryWrapper.eq("dr", 0);
        List<QuotadesigndetailEntity> list = quotadesigndetailService.list(queryWrapper);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("quotadesigndetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportQuotadesignFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<QuotadesigndetailVO> list, HttpServletResponse response) {
        List<QuotadesigndetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                QuotadesigndetailVO quotadesigndetailVO = list.get(i);
                quotadesigndetailVO.setSort(String.valueOf(i + 1));
                concatList.add(quotadesigndetailVO);
            }
        }

        //children拍平
        List<QuotadesigndetailVO> allList = handleList(list, concatList);
        //按序号排序
        Collections.sort(allList, new Comparator<QuotadesigndetailVO>() {
            @Override
            public int compare(QuotadesigndetailVO o1, QuotadesigndetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("quotadesigndetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<QuotadesigndetailVO> handleList(List<QuotadesigndetailVO> list, List<QuotadesigndetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            QuotadesigndetailVO quotadesigndetailVO = list.get(i);
            List<QuotadesigndetailVO> children = quotadesigndetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }

}
