package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgetEntity;
import com.ejianc.business.change.service.IChangeconsdrawbudgetService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetVO;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetdetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 施工预算图变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeconsdrawbudget")
public class ChangeconsdrawbudgetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-changeconsdrawbudget";//此处需要根据实际修改

    @Autowired
    private IChangeconsdrawbudgetService service;

    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByConsdrawbudgetId")
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgetVO> queryDetailByConsdrawbudgetId(@RequestParam(value = "consdrawbudgetId") Long consdrawbudgetId) {
        ConsdrawbudgetEntity consdrawbudgetEntity = consdrawbudgetService.selectById(consdrawbudgetId);
        ChangeconsdrawbudgetVO changeVO = BeanMapper.map(consdrawbudgetEntity, ChangeconsdrawbudgetVO.class);
        Long id = IdWorker.getId();
        changeVO.setConsdrawbudgetId(consdrawbudgetId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //限额设计指标分析清单
        List<ConsdrawbudgetdetailEntity> consdrawbudgetdetailEntities = consdrawbudgetEntity.getConsdrawbudgetdetailEntities();
        if(consdrawbudgetdetailEntities!=null&&consdrawbudgetdetailEntities.size()>0){
            List<ChangeconsdrawbudgetdetailVO> changeconsdrawbudgetdetailVOS = new ArrayList<>();
            for(ConsdrawbudgetdetailEntity entity : consdrawbudgetdetailEntities){
                ChangeconsdrawbudgetdetailVO vo = BeanMapper.map(entity, ChangeconsdrawbudgetdetailVO.class);
                vo.setChangeMid(id);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changeconsdrawbudgetdetailVOS.add(vo);
            }
            changeVO.setChangeconsdrawbudgetdetailEntities(changeconsdrawbudgetdetailVOS);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgetVO> saveOrUpdate(@RequestBody ChangeconsdrawbudgetVO saveorUpdateVO) {
        return service.saveChange(saveorUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgetVO> queryDetail(Long id) {
    	ChangeconsdrawbudgetEntity entity = service.selectById(id);
    	ChangeconsdrawbudgetVO vo = BeanMapper.map(entity, ChangeconsdrawbudgetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeconsdrawbudgetVO> vos) {
        service.removeByIds(vos.stream().map(ChangeconsdrawbudgetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeconsdrawbudgetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeconsdrawbudgetEntity> page = service.queryPage(param,false);
        IPage<ChangeconsdrawbudgetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeconsdrawbudgetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeconsdrawbudgetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changeconsdrawbudget-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refChangeconsdrawbudgetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeconsdrawbudgetVO>> refChangeconsdrawbudgetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeconsdrawbudgetEntity> page = service.queryPage(param,false);
        IPage<ChangeconsdrawbudgetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeconsdrawbudgetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
