package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.DesignestimatedetailEntity;
import com.ejianc.business.bedget.service.IDesignestimatedetailService;
import com.ejianc.business.bedget.vo.DesignestimatedetailVO;
import com.ejianc.business.bedget.vo.MaterialanalysisVO;
import com.ejianc.business.change.bean.ChangedesignestimatedetailEntity;
import com.ejianc.business.change.service.IChangedesignestimatedetailService;
import com.ejianc.business.change.vo.ChangedesignestimateVO;
import com.ejianc.business.change.vo.ChangedesignestimatedetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设计概算清单导入导出
 */
@Controller
@RequestMapping("changeDesignestimateExport")
public class ExeclChangeDesignestimateController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangedesignestimatedetailService changedesignestimatedetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloaddesignestimate")
    @ResponseBody
    public void downloaddesignestimate(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "designestimatedetail-import.xlsx", "施工图预算材料分析清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportdesignestimate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportdesignestimate(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangedesignestimatedetailVO> successList = new ArrayList<>();
        List<ChangedesignestimatedetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    ChangedesignestimatedetailVO changedesignestimatedetailVO = new ChangedesignestimatedetailVO();
                    changedesignestimatedetailVO.setId(IdWorker.getId());//id
                    changedesignestimatedetailVO.setSort(datas.get(0)); // 序号
                    changedesignestimatedetailVO.setCode(StringUtils.isNotBlank(datas.get(1))? datas.get(1):null); // 编码
                    changedesignestimatedetailVO.setName(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 名称
                    changedesignestimatedetailVO.setProjectCost(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 项目造价(元)
                    changedesignestimatedetailVO.setCostPercent(StringUtils.isNotBlank(datas.get(4))?new BigDecimal(datas.get(4)):null); // 占造价百分比(%)
                    changedesignestimatedetailVO.setProjectScale(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 工程规模(m²或m)
                    changedesignestimatedetailVO.setUnitCost(StringUtils.isNotBlank(datas.get(6))?datas.get(6):null); // 单位造价(元/m²或元/m)
                    changedesignestimatedetailVO.setBudgeTotal(StringUtils.isNotBlank(datas.get(7))?new BigDecimal(datas.get(7)):null); // 预算合计
                    changedesignestimatedetailVO.setLaborCost(StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null); // 人工费
                    changedesignestimatedetailVO.setMaterialCost(StringUtils.isNotBlank(datas.get(9))?new BigDecimal(datas.get(9)):null); // 材料费
                    changedesignestimatedetailVO.setMachineryCost(StringUtils.isNotBlank(datas.get(10))?new BigDecimal(datas.get(10)):null); // 机械费
                    changedesignestimatedetailVO.setBusinessManagerCost(StringUtils.isNotBlank(datas.get(11))?new BigDecimal(datas.get(11)):null); // 企业管理费
                    changedesignestimatedetailVO.setProfit(StringUtils.isNotBlank(datas.get(12))?new BigDecimal(datas.get(12)):null); // 利润
                    changedesignestimatedetailVO.setMeasureItemsTotal(StringUtils.isNotBlank(datas.get(13))?new BigDecimal(datas.get(13)):null); // 措施项目合计
                    changedesignestimatedetailVO.setSafeCivilizedConstructionCost(StringUtils.isNotBlank(datas.get(14))?new BigDecimal(datas.get(14)):null); // 安全文明施工费
                    changedesignestimatedetailVO.setTransportConsumeCost(StringUtils.isNotBlank(datas.get(15))?new BigDecimal(datas.get(15)):null); // 其中:施工垃圾场外运输和消纳费
                    changedesignestimatedetailVO.setScatteredExpenseseTotal(StringUtils.isNotBlank(datas.get(16))?new BigDecimal(datas.get(16)):null); //零星工程费
                    changedesignestimatedetailVO.setFeesTotal(StringUtils.isNotBlank(datas.get(17))?new BigDecimal(datas.get(17)):null); // 规费合计
                    changedesignestimatedetailVO.setTaxTotal(StringUtils.isNotBlank(datas.get(18))?new BigDecimal(datas.get(18)):null); //税金
                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        materialanalysisdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        materialanalysisdetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        materialanalysisdetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        materialanalysisdetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        materialanalysisdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        materialanalysisdetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        materialanalysisdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }*/
                    successList.add(changedesignestimatedetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportdesignestimateFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportdesignestimateFromDatabase(@RequestBody ChangedesignestimateVO materialanalysisVO, HttpServletResponse response) {
        QueryWrapper<ChangedesignestimatedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", materialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangedesignestimatedetailEntity> list = changedesignestimatedetailService.list(queryWrapper);
        List<ChangedesignestimatedetailVO> changedesignestimatedetailVOList = BeanMapper.mapList(list, ChangedesignestimatedetailVO.class);
        if(changedesignestimatedetailVOList != null && changedesignestimatedetailVOList.size() > 0){
            for (int i = 0; i < changedesignestimatedetailVOList.size(); i++) {
                ChangedesignestimatedetailVO changedesignestimatedetailVO = changedesignestimatedetailVOList.get(i);
                changedesignestimatedetailVO.setSort(String.valueOf(i+1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", changedesignestimatedetailVOList);
        ExcelExport.getInstance().export("designestimatedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportdesignestimateFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportdesignestimateFromPage(@RequestBody List<ChangedesignestimatedetailVO> list, HttpServletResponse response) {
        if(list != null){
            for (int i = 0; i < list.size(); i++) {
                ChangedesignestimatedetailVO designestimatedetailVO = list.get(i);
                designestimatedetailVO.setSort(String.valueOf(i+1));
            }
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designestimatedetail-export.xlsx", beans, response);
    }

}
