package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotaanalysisEntity;
import com.ejianc.business.bedget.service.IQuotaanalysisService;
import com.ejianc.business.change.bean.ChangeQuotaanalysisEntity;
import com.ejianc.business.change.mapper.ChangeQuotaanalysisMapper;
import com.ejianc.business.change.service.IChangeQuotaanalysisService;
import com.ejianc.business.change.vo.ChangeQuotaanalysisVO;
import com.ejianc.business.record.bean.RecordQuotaanalysisEntity;
import com.ejianc.business.record.service.IRecordQuotaanalysisService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;


import java.util.List;
import java.util.stream.Collectors;

/**
 * 限额设计指标分析变更表
 * 
 * @author generator
 * 
 */
@Service("changeQuotaanalysisService")
public class ChangeQuotaanalysisServiceImpl extends BaseServiceImpl<ChangeQuotaanalysisMapper, ChangeQuotaanalysisEntity> implements IChangeQuotaanalysisService {


    @Autowired
    private IQuotaanalysisService quotaanalysisService;

    @Autowired
    private IRecordQuotaanalysisService recordQuotaanalysisService;
    @Override
    public CommonResponse<ChangeQuotaanalysisVO> saveChange(ChangeQuotaanalysisVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeQuotaanalysisEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeQuotaanalysisEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeQuotaanalysisEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeQuotaanalysisEntity> queryWrapper = new QueryWrapper<ChangeQuotaanalysisEntity>();
        queryWrapper.eq("quotaanalysis_id", saveOrUpdateVO.getQuotaanalysisId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeQuotaanalysisEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeQuotaanalysisVO vo = BeanMapper.map(entity, ChangeQuotaanalysisVO.class);
        vo.setChangeQuotaanalysisdetailEntities(saveOrUpdateVO.getChangeQuotaanalysisdetailEntities());
        vo.setRecordQuotaanalysisList(saveOrUpdateVO.getRecordQuotaanalysisList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            QuotaanalysisEntity quotaanalysisEntity = quotaanalysisService.selectById(vo.getQuotaanalysisId());
            quotaanalysisEntity.setChangeState("2");//状态改为变更中
            quotaanalysisEntity.setChangeId(vo.getId());
            quotaanalysisService.saveOrUpdate(quotaanalysisEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<ChangeQuotaanalysisVO> vos) {
        for(ChangeQuotaanalysisVO vo : vos){
            ChangeQuotaanalysisEntity entity = this.getById(vo.getId());
            QuotaanalysisEntity quotaanalysisEntity = quotaanalysisService.selectById(entity.getQuotaanalysisId());
            QueryWrapper<RecordQuotaanalysisEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("quotaanalysis_id", entity.getId());
            List<RecordQuotaanalysisEntity> records = recordQuotaanalysisService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                quotaanalysisEntity.setChangeState("3");//状态改为已变更
            }else{
                quotaanalysisEntity.setChangeState("1");//状态改为未变更
            }
            quotaanalysisEntity.setChangeId(null);
            quotaanalysisService.saveOrUpdate(quotaanalysisEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeQuotaanalysisVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }
}
