package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgetEntity;
import com.ejianc.business.change.bean.ChangeconsdrawbudgetdetailEntity;
import com.ejianc.business.change.service.IChangeconsdrawbudgetService;
import com.ejianc.business.record.bean.RecordconsdrawbudgetEntity;
import com.ejianc.business.record.bean.RecordconsdrawbudgetdetailEntity;
import com.ejianc.business.record.service.IRecordconsdrawbudgetService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeconsdrawbudget") 
public class ChangeconsdrawbudgetBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Consdrawbudget = "zjkj-consdrawbudget";//施工图预算
	private static final String Consdrawbudget_CHANGE = "zjkj-consdrawbudgetChange";//施工图预算变更
	private static final String Consdrawbudget_RECORD = "zjkj-consdrawbudgetRecord";//施工图预算变更记录

	//单据类型
	private static final String Consdrawbudget_BILLTYPE_CODE = "BT202202000036";//施工图预算
	private static final String Consdrawbudget_CHANGE_BILLTYPE_CODE = "BT202202000037";//施工图预算变更
	private static final String Consdrawbudget_RECORD_BILLTYPE_CODE = "BT202202000038";//施工图预算变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeconsdrawbudgetService changeconsdrawbudgetService;
	@Autowired
	private IConsdrawbudgetService consdrawbudgetService;
	@Autowired
	private IRecordconsdrawbudgetService recordconsdrawbudgetService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeconsdrawbudgetEntity changeEntity = changeconsdrawbudgetService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getConsdrawbudgetId());
		ConsdrawbudgetEntity consdrawbudgetEntity = consdrawbudgetService.selectById(changeEntity.getConsdrawbudgetId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordconsdrawbudgetEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("consdrawbudget_id", consdrawbudgetEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordconsdrawbudgetService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordconsdrawbudgetEntity recordconsdrawbudgetEntity = BeanMapper.map(consdrawbudgetEntity, RecordconsdrawbudgetEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordconsdrawbudgetEntity);
		recordconsdrawbudgetEntity.setBillState(null);
		recordconsdrawbudgetEntity.setConsdrawbudgetId(consdrawbudgetEntity.getId());
		recordconsdrawbudgetEntity.setConsdrawbudgetCode(consdrawbudgetEntity.getBillCode()+"-"+(count+1));
		recordconsdrawbudgetEntity.setId(recordId);
		recordconsdrawbudgetEntity.setBillCode(consdrawbudgetEntity.getBillCode());
		recordconsdrawbudgetEntity.setChangeReason(changeEntity.getChangeReason());
		recordconsdrawbudgetEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<ConsdrawbudgetdetailEntity> consdrawbudgetdetailEntities = consdrawbudgetEntity.getConsdrawbudgetdetailEntities();
		if(consdrawbudgetdetailEntities!=null&&consdrawbudgetdetailEntities.size()>0){
			List<RecordconsdrawbudgetdetailEntity> recordconsdrawbudgetdetailEntities = new ArrayList<>();
			for(ConsdrawbudgetdetailEntity entity : consdrawbudgetdetailEntities){
				RecordconsdrawbudgetdetailEntity reEntity = BeanMapper.map(entity, RecordconsdrawbudgetdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordMid(recordId);
				recordconsdrawbudgetdetailEntities.add(reEntity);
			}
			recordconsdrawbudgetEntity.setRecordconsdrawbudgetdetailEntities(recordconsdrawbudgetdetailEntities);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Consdrawbudget_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Consdrawbudget_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(consdrawbudgetEntity.getId().toString(), sourceBillType, Consdrawbudget , recordId.toString(), targetBillType, Consdrawbudget_RECORD);
		recordconsdrawbudgetService.saveOrUpdate(recordconsdrawbudgetEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + consdrawbudgetEntity.getCreateUserCode());
		//3、修改当前单据状态
		ConsdrawbudgetEntity newConsdrawbudgetEntity = BeanMapper.map(changeEntity, ConsdrawbudgetEntity.class);
		newConsdrawbudgetEntity.setChangeState("3");//状态改为已变更
		newConsdrawbudgetEntity.setChangeId(null);
		newConsdrawbudgetEntity.setBillState(consdrawbudgetEntity.getBillState());
		newConsdrawbudgetEntity.setId(consdrawbudgetEntity.getId());
		newConsdrawbudgetEntity.setCreateTime(consdrawbudgetEntity.getCreateTime());
		newConsdrawbudgetEntity.setCreateUserCode(consdrawbudgetEntity.getCreateUserCode());
		newConsdrawbudgetEntity.setTenantId(consdrawbudgetEntity.getTenantId());
		newConsdrawbudgetEntity.setVersion(consdrawbudgetEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangeconsdrawbudgetdetailEntity> changeconsdrawbudgetdetailEntities = changeEntity.getChangeconsdrawbudgetdetailEntities();
		if(changeconsdrawbudgetdetailEntities!=null&&changeconsdrawbudgetdetailEntities.size()>0){
			List<ConsdrawbudgetdetailEntity> newConsdrawbudgetdetailList = BeanMapper.mapList(changeconsdrawbudgetdetailEntities, ConsdrawbudgetdetailEntity.class);
			newConsdrawbudgetdetailList.addAll(consdrawbudgetdetailEntities);
			newConsdrawbudgetEntity.setConsdrawbudgetdetailEntities(newConsdrawbudgetdetailList);
		}
		logger.info("---------保存--------");
		consdrawbudgetService.saveOrUpdate(newConsdrawbudgetEntity, false);

		sourceBillType = Consdrawbudget_CHANGE_BILLTYPE_CODE;
		targetBillType = Consdrawbudget_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Consdrawbudget_CHANGE, consdrawbudgetEntity.getId().toString(), targetBillType, Consdrawbudget);
		recordconsdrawbudgetService.saveOrUpdate(recordconsdrawbudgetEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
