package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgetEntity;
import com.ejianc.business.change.mapper.ChangeconsdrawbudgetMapper;
import com.ejianc.business.change.service.IChangeconsdrawbudgetService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 施工预算图变更
 * 
 * @author generator
 * 
 */
@Service("changeconsdrawbudgetService")
public class ChangeconsdrawbudgetServiceImpl extends BaseServiceImpl<ChangeconsdrawbudgetMapper, ChangeconsdrawbudgetEntity> implements IChangeconsdrawbudgetService {
    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;
    @Override
    public CommonResponse<ChangeconsdrawbudgetVO> saveChange(ChangeconsdrawbudgetVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeconsdrawbudgetEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeconsdrawbudgetEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeconsdrawbudgetEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeconsdrawbudgetEntity> queryWrapper = new QueryWrapper<ChangeconsdrawbudgetEntity>();
        queryWrapper.eq("consdrawbudget_id", saveOrUpdateVO.getConsdrawbudgetId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeconsdrawbudgetEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //施工图预算子表
        this.saveOrUpdate(entity, false);

        ChangeconsdrawbudgetVO vo = BeanMapper.map(entity, ChangeconsdrawbudgetVO.class);
        vo.setChangeconsdrawbudgetdetailEntities(saveOrUpdateVO.getChangeconsdrawbudgetdetailEntities());
        vo.setRecordconsdrawbudgetdetailVOS(saveOrUpdateVO.getRecordconsdrawbudgetdetailVOS());
        if(!exitBill){
            //查询原始单据信息，将状态改为变更中
            ConsdrawbudgetEntity consdrawbudgetEntity = consdrawbudgetService.selectById(vo.getConsdrawbudgetId());
            consdrawbudgetEntity.setChangeState("2");//状态改为变更中
            consdrawbudgetEntity.setChangeId(vo.getId());
            consdrawbudgetService.saveOrUpdate(consdrawbudgetEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
