package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.IDesignestimateService;
import com.ejianc.business.bedget.service.IDesignestimatedetailService;
import com.ejianc.business.bedget.vo.EstimatesummarydetailVO;
import com.ejianc.business.bedget.vo.QuotasummarydetailVO;
import com.ejianc.business.record.bean.RecorddesignestimateEntity;
import com.ejianc.business.record.bean.RecordestimatesummaryEntity;
import com.ejianc.business.record.service.IRecordestimatesummaryService;
import com.ejianc.business.record.vo.RecorddesignestimateVO;
import com.ejianc.business.record.vo.RecordestimatesummaryVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.service.IEstimatesummaryService;
import com.ejianc.business.bedget.vo.EstimatesummaryVO;

/**
 * 设计概算汇总表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("estimatesummary")
public class EstimatesummaryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanage-budgetestimatesummary";//此处需要根据实际修改

    @Autowired
    private IEstimatesummaryService service;
    @Autowired
    private IDesignestimateService designestimateService;
    @Autowired
    private IDesignestimatedetailService designestimatedetailService;


    @Autowired
    private IRecordestimatesummaryService recordestimatesummaryService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EstimatesummaryVO> saveOrUpdate(@RequestBody EstimatesummaryVO saveorUpdateVO) {
    	EstimatesummaryEntity entity = BeanMapper.map(saveorUpdateVO, EstimatesummaryEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            QueryWrapper<EstimatesummaryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id", entity.getProjectId());
            queryWrapper.eq("dr", "0");
            List<EstimatesummaryEntity> pro = service.list(queryWrapper);
            if(pro.size() > 0){
                throw new BusinessException("该项目已经创建一个设计概算汇总，不允许重复创建!");
            }

            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	EstimatesummaryVO vo = BeanMapper.map(entity, EstimatesummaryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EstimatesummaryVO> queryDetail(Long id) {
    	EstimatesummaryEntity entity = service.selectById(id);
    	EstimatesummaryVO vo = BeanMapper.map(entity, EstimatesummaryVO.class);
        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordestimatesummaryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("budgetestimatesummary_id", vo.getId());
            List<RecordestimatesummaryEntity> records = recordestimatesummaryService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordestimatesummaryVOList(BeanMapper.mapList(records, RecordestimatesummaryVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EstimatesummaryVO> vos) {
        service.removeByIds(vos.stream().map(EstimatesummaryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EstimatesummaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EstimatesummaryEntity> page = service.queryPage(param,false);
        IPage<EstimatesummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EstimatesummaryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EstimatesummaryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Estimatesummary-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refEstimatesummaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EstimatesummaryVO>> refEstimatesummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EstimatesummaryEntity> page = service.queryPage(param,false);
        IPage<EstimatesummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EstimatesummaryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    /**
     * @Description queryDetail 查询详情
     * @param projectId
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<EstimatesummarydetailVO>> queryDetailList(Long projectId) {
        List<EstimatesummarydetailVO> vo = new ArrayList<>();
        //根据项目id查询设计概算表数据
        QueryWrapper<DesignestimateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("dr", 0);
        DesignestimateEntity entity = designestimateService.getOne(queryWrapper);
        if(entity == null){
            throw  new BusinessException("您选择的项目没有设计概算,请选择别的项目");
        }else{
            //根据主表id和tpid为空 查询子表第一层数据
            QueryWrapper<DesignestimatedetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("mid",entity.getId());
            queryWrapper1.eq("dr", 0);
            queryWrapper1.eq("tpid", "");
            int sort = 0;
            List<DesignestimatedetailEntity> list = designestimatedetailService.list(queryWrapper1);
            if(list == null){
                throw  new BusinessException("您选择的项目没有设计概算清单,请选择别的项目");
            }else{
                for(DesignestimatedetailEntity designestimatedetailEntity : list){
                    sort += 1;
                    EstimatesummarydetailVO estimatesummarydetailVO = new EstimatesummarydetailVO();
                    estimatesummarydetailVO.setSort(String.valueOf(sort));
                    estimatesummarydetailVO.setInventoryCode(designestimatedetailEntity.getCode());
                    estimatesummarydetailVO.setEngineeringName(designestimatedetailEntity.getName());
                    estimatesummarydetailVO.setTid(designestimatedetailEntity.getTid());
                    estimatesummarydetailVO.setTpid(designestimatedetailEntity.getTpid());
                    estimatesummarydetailVO.setRowState("add");
                    //根据主表id和第一层数据的父id查询第二层数据
                    QueryWrapper<DesignestimatedetailEntity> queryWrapper2 = new QueryWrapper<>();
                    queryWrapper2.eq("mid",entity.getId());
                    queryWrapper2.eq("dr", 0);
                    queryWrapper2.eq("tpid", designestimatedetailEntity.getTid());
                    List<DesignestimatedetailEntity> list1 = designestimatedetailService.list(queryWrapper2);
                    if(list1 != null){
                        int sortItem = 0;
                        for(DesignestimatedetailEntity designestimatedetailEntity1 : list1){
                            sortItem += 1;
                            List<EstimatesummarydetailVO> estimatesummarydetailVOs = new ArrayList<>();
                            EstimatesummarydetailVO estimatesummarydetailVO1 = new EstimatesummarydetailVO();
                            estimatesummarydetailVO1.setSort(sort + "." + sortItem);
                            estimatesummarydetailVO1.setInventoryCode(designestimatedetailEntity1.getCode());
                            estimatesummarydetailVO1.setEngineeringName(designestimatedetailEntity1.getName());
                            estimatesummarydetailVO1.setTid(designestimatedetailEntity1.getTid());
                            estimatesummarydetailVO1.setTpid(designestimatedetailEntity1.getTpid());
                            estimatesummarydetailVO1.setRowState("add");
                            estimatesummarydetailVOs.add(estimatesummarydetailVO1);
                            estimatesummarydetailVO.setChildren(estimatesummarydetailVOs);
                        }
                    }
                    vo.add(estimatesummarydetailVO);
                }
            }
        }
        return CommonResponse.success(vo);
    }
}
