package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.vo.QuotadesigndetailVO;
import com.ejianc.business.bedget.vo.QuotasummaryVO;
import com.ejianc.business.record.bean.RecordquotadesignEntity;
import com.ejianc.business.record.service.IRecordquotadesignService;
import com.ejianc.business.record.vo.RecordquotadesignVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.bedget.vo.QuotadesignVO;

/**
 * 限额设计表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("quotadesign")
public class QuotadesignController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanage-quotadesign";//此处需要根据实际修改

    @Autowired
    private IQuotadesignService service;
    @Autowired
    private IRecordquotadesignService recordquotadesignService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuotadesignVO> saveOrUpdate(@RequestBody QuotadesignVO saveorUpdateVO) {
    	QuotadesignEntity entity = BeanMapper.map(saveorUpdateVO, QuotadesignEntity.class);

        QueryWrapper<QuotadesignEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        queryWrapper.ne("id", saveorUpdateVO.getId());
        List<QuotadesignEntity> pro = service.list(queryWrapper);
        if(pro.size() > 0){
            throw new BusinessException("该项目已经创建一个限额设计，不允许重复创建!");
        }

    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	QuotadesignVO vo = BeanMapper.map(entity, QuotadesignVO.class);
        //构建树形结构
        List<QuotadesigndetailVO> quotadesigndetailVO = vo.getQuotadesigndetailEntities();
        List<QuotadesigndetailVO> resQuotadesigndetailVO = createTreeData(quotadesigndetailVO);
        vo.setQuotadesigndetailEntities(resQuotadesigndetailVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuotadesignVO> queryDetail(Long id) {
    	QuotadesignEntity entity = service.selectById(id);
    	QuotadesignVO vo = BeanMapper.map(entity, QuotadesignVO.class);

        //构建树形结构
        List<QuotadesigndetailVO> quotadesigndetailVO = vo.getQuotadesigndetailEntities();
        List<QuotadesigndetailVO> resQuotadesigndetailVO = createTreeData(quotadesigndetailVO);
        vo.setQuotadesigndetailEntities(resQuotadesigndetailVO);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordquotadesignEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", vo.getId());
            List<RecordquotadesignEntity> records = recordquotadesignService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordquotadesignList(BeanMapper.mapList(records, RecordquotadesignVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuotadesignVO> vos) {
        service.removeByIds(vos.stream().map(QuotadesignVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuotadesignVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("operator_name");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<QuotadesignEntity> page = service.queryPage(param,false);
        IPage<QuotadesignVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotadesignVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryDetail 查询该项目是否已有限额设计指标分析单据
     * @param id
     * @param projectId
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        QueryWrapper<QuotadesignEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        List<QuotadesignEntity> entityList = service.list(queryWrapper);

        if(id == null || id == 0){
            if(entityList.size() > 0){
                return CommonResponse.success("该项目已经创建一个限额设计，请选择其他项目!", "0");
            }
        }else {
            for (int i = 0; i < entityList.size(); i++) {
                if(!entityList.get(i).getId().equals(id)){
                    return CommonResponse.success("该项目已经创建一个限额设计，请选择其他项目!", "0");
                }
            }
        }

        return CommonResponse.success("查询成功！", "1");
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<QuotadesignEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<QuotadesignVO> quotadesignVOList = BeanMapper.mapList(list, QuotadesignVO.class);
        for (int i = 0; i < quotadesignVOList.size(); i++) {
            QuotadesignVO quotadesignVO = quotadesignVOList.get(i);
            quotadesignVO.setSort(String.valueOf(i+1));
            if (quotadesignVO.getCreateTime()!=null){
                quotadesignVO.setCreateTimeShow(DateUtils.dateSimple2(quotadesignVO.getCreateTime()));
            }
            String billStateStr = quotadesignVO.getBillState().toString();
            String changeState = quotadesignVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                quotadesignVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                quotadesignVO.setChangeState(changeState);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", quotadesignVOList);
        ExcelExport.getInstance().export("Quotadesign-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refQuotadesignData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuotadesignVO>> refQuotadesignData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<QuotadesignEntity> page = service.queryPage(param,false);
        IPage<QuotadesignVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QuotadesignVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public static List<QuotadesigndetailVO> createTreeData(List<QuotadesigndetailVO> list) {
        List<QuotadesigndetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, QuotadesigndetailVO> listMap = new HashMap<>();
        for(QuotadesigndetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            QuotadesigndetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            QuotadesigndetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<QuotadesigndetailVO> child = (List<QuotadesigndetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<QuotadesigndetailVO> children = new ArrayList<QuotadesigndetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
    /**
     * 页面新增后重新构建树
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/refreshData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<QuotadesigndetailVO> list, HttpServletResponse response) {
        JSONObject json = new JSONObject();
        Map<String,QuotadesigndetailVO> map = new HashMap<>();
        QuotadesigndetailVO add = list.get(list.size() - 1);
        add.setId(IdWorker.getId());
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getSonItemCode());
        if("01".equals(add.getSonItemCode())&&add.getSonItemName().contains("装饰")){
            add.setInnercode("a1");
        }
        //判断是否是装饰工程的子节点编码
        if(add.getSonItemCode().length()>=4){
            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
            String code = add.getSonItemCode().substring(0,4);
            if("0111".equals(code)||"0112".equals(code)||"0113".equals(code)||"0114".equals(code)||"0115".equals(code)){
//	    		若是的话，将内码改为a1xx
                add.setInnercode("a1"+add.getSonItemCode().substring(2,add.getSonItemCode().length()));
            }
        }
        for(QuotadesigndetailVO vo : list){
            map.put(vo.getInnercode(), vo);
            if(!add.getId().equals(vo.getId()) && add.getInnercode().equals(vo.getInnercode())){
                throw new BusinessException("子目编码已存在，请重新填写");
            }
        }
        //设置父级id
        for(QuotadesigndetailVO vo : list){
            String innercode = vo.getInnercode();
            Long pid = null;
            if(innercode.length()==2){
                //最上级
            }else if(innercode.length()==4){
                String pcode = innercode.substring(0, 2);
                //有父节点
                pid = this.setPid(pcode, map);

            }else if(innercode.length()==6){
                String pcode = innercode.substring(0, 4);
                //有父节点
                pid = this.setPid(pcode, map);
            }else if(innercode.length()>6){
                String pcode = innercode.substring(0, 6);
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if(pid != null){
                vo.setTpid(pid.toString());
            }else {
                vo.setTpid("");
            }
        }

        //清空父级部分数据
        list = clearPData(add, list);

        //按子目编码排序
        Collections.sort(list, new Comparator<QuotadesigndetailVO>() {
            @Override
            public int compare(QuotadesigndetailVO o1, QuotadesigndetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        //构建树
        List<QuotadesigndetailVO> result = createTreeData(list);

        json.put("dataSource", result);
        return CommonResponse.success(json);
    }

    private List<QuotadesigndetailVO> clearPData(QuotadesigndetailVO handleVO, List<QuotadesigndetailVO> list) {
        if(list == null || list.size() == 0){
            return null;
        }

        String pid = handleVO.getTpid();
        if(pid == null || TextUtils.isEmpty(pid)){
            return list;
        }

        for (int i = 0; i < list.size(); i++) {
            QuotadesigndetailVO vo = list.get(i);
            if(pid.equals(vo.getTid())){
                //清空父级单价和工程量
                vo.setEngineering(null);
                vo.setLabor(null);
                vo.setMaterial(null);
                vo.setMechanical(null);
                vo.setManagement(null);
                vo.setProfit(null);
                vo.setUnitPrice(null);

                if(vo.getTpid() != null && !TextUtils.isEmpty(vo.getTpid())){
                    clearPData(vo, list);
                    break;
                }
            }
        }

        return list;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode,Map<String,QuotadesigndetailVO> map){
        if(map.get(pcode)!=null){
            return Long.valueOf(map.get(pcode).getTid());
        }else{
            //父级没有找到，则继续往上找
            if(pcode.length()==2){
                //最上级
                return null;
            }else if(pcode.length()==4){
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            }else if(pcode.length()==6){
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            }else if(pcode.length()>6){
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            }else{
                return null;
            }
        }
    }
}
